function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
import CompanyInformationForm from "./forms/CompanyInformationForm.js";
import UpliftSettingsForm from "./forms/UpliftSettingsForm.js";
import ContentSettingsForm from "./forms/ContentSettingsForm.js";
import RobotSettingsForm from "./forms/RobotSettingsForm.js";
import InjectionsForm from "./forms/InjectionsForm.js";
import AddPhoneNumberButton from "./components/AddPhoneNumberButton.js";
import PhoneNumber from "./components/PhoneNumber.js";
import AddFaxNumberButton from "./components/AddFaxNumberButton.js";
import FaxNumber from "./components/FaxNumber.js";
import UpdateCoreButton from "./components/UpdateCoreButton.js";
import ReRegisterBuildButton from "./components/ReRegisterBuildButton.js";
import AddAddressButton from "./components/AddAddressButton.js";
import AdditionalAddress from "./components/AdditionalAddress.js";
var Settings = /*#__PURE__*/function () {
  function Settings() {
    _classCallCheck(this, Settings);
    _defineProperty(this, "phoneNumbersJSONContainer", document.querySelector("#phone-numbers-initial-load-json"));
    _defineProperty(this, "faxNumbersJSONContainer", document.querySelector("#fax-numbers-initial-load-json"));
    _defineProperty(this, "additionalAddressesJSONContainer", document.querySelector("#additional-addresses-initial-load-json"));
    window.addEventListener("keydown", function (e) {
      if (e.ctrlKey) {
        if (e.key.toLowerCase() === "s") {
          e.preventDefault();

          // Save all forms
          CompanyInformationForm.onSubmit();
          UpliftSettingsForm.onSubmit();
          ContentSettingsForm.onSubmit();
          RobotSettingsForm.onSubmit();
        }
      }
    });
    this.loadExistingPhoneNumbers();
    this.loadExistingFaxNumbers();
    this.loadExistingAdditionalAddresses();
    new AddAddressButton();
  }
  return _createClass(Settings, [{
    key: "loadExistingPhoneNumbers",
    value: function loadExistingPhoneNumbers() {
      try {
        var phoneNumbers = JSON.parse(this.phoneNumbersJSONContainer.textContent);
        if (phoneNumbers.length > 0) {
          AddPhoneNumberButton.noPhoneNumberMessage.style.display = "none";
        }
        var _iterator = _createForOfIteratorHelper(phoneNumbers),
          _step;
        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var number = _step.value;
            new PhoneNumber(number);
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }
      } catch (jsonError) {}
    }
  }, {
    key: "loadExistingFaxNumbers",
    value: function loadExistingFaxNumbers() {
      try {
        var faxNumbers = JSON.parse(this.faxNumbersJSONContainer.textContent);
        if (faxNumbers.length > 0) {
          AddFaxNumberButton.noFaxNumberMessage.style.display = "none";
        }
        var _iterator2 = _createForOfIteratorHelper(faxNumbers),
          _step2;
        try {
          for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
            var number = _step2.value;
            new FaxNumber(number);
          }
        } catch (err) {
          _iterator2.e(err);
        } finally {
          _iterator2.f();
        }
      } catch (jsonError) {}
    }
  }, {
    key: "loadExistingAdditionalAddresses",
    value: function loadExistingAdditionalAddresses() {
      try {
        var additionalAddressCustomSettings = JSON.parse(this.additionalAddressesJSONContainer.textContent);

        /**
         * The 'value' is a JSON string. Must be parsed.
         * @type {{id: int, name: string, value: string}}
         */
        var _iterator3 = _createForOfIteratorHelper(additionalAddressCustomSettings),
          _step3;
        try {
          for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
            var additionalAddressCustomSetting = _step3.value;
            /**
             * @type {{street: string, city: string, state: string, postal: string, country: string}}
             */
            var address = JSON.parse(additionalAddressCustomSetting.value);
            var additionalAddressInstance = new AdditionalAddress(additionalAddressCustomSetting.id);
            additionalAddressInstance.render();
            additionalAddressInstance.loadExistingData(address.street, address.city, address.state, address.postal, address.country);
          }
        } catch (err) {
          _iterator3.e(err);
        } finally {
          _iterator3.f();
        }
      } catch (jsonError) {}
    }
  }]);
}();
export default new Settings();