function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
var PageData = /*#__PURE__*/function () {
  /**
   * @param {PageComponent} pageComponent
   * @param {string} dataType
   * @param {string} dataValue
   */
  function PageData(pageComponent, dataType, dataValue) {
    _classCallCheck(this, PageData);
    _defineProperty(this, "dataType", void 0);
    _defineProperty(this, "dataValue", void 0);
    _defineProperty(this, "dom", void 0);
    this.id = this.constructor.nextID++;
    this.pageComponent = pageComponent;
    this.dataType = dataType;
    this.dataValue = dataValue;
    this.dom = this.getDOM();
    this.constructor.cache.push(this);
    pageComponent.pageDatas.push(this);
  }
  return _createClass(PageData, [{
    key: "getDOM",
    value: function getDOM() {
      var _this = this;
      var template = document.createElement("div");
      template.classList.add("page-parent-component");
      template.innerHTML = "\n\t\t\t<div class=\"card\">\n\t\t\t\t<div class=\"card-header\">\n\t\t\t\t\t<h6 class=\"mb-0\">".concat(this.dataType, "</h6>\n\t\t\t\t</div>\n\t\t\t\t<div class=\"card-body\">\n\t\t\t\t\t<div class=\"input-group\">\n\t\t\t\t\t\t<label for=\"data-value-input-").concat(this.id, "\" class=\"input-group-text\">Value</label>\n\t\t\t\t\t\t<input type=\"text\" class=\"form-control data-value-input\" name=\"data-value\" id=\"data-value-input-").concat(this.id, "\" value=\"").concat(this.dataValue, "\">\n\t\t\t\t\t</div>\n\t\t\t\t\t<div>\n\t\t\t\t\t\t<button type=\"button\" class=\"btn btn-sm btn-link text-danger delete-button\">\n\t\t\t\t\t\t\t<i class=\"bi bi-trash-fill\"></i>\n\t\t\t\t\t\t\t<span>Delete</span>\n\t\t\t\t\t\t</button>\n\t\t\t\t\t</div>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t");
      var dataValueInput = template.querySelector(".data-value-input");
      var deleteButton = template.querySelector(".delete-button");
      dataValueInput.addEventListener("input", function () {
        _this.dataValue = dataValueInput.value;
      });
      deleteButton.addEventListener("click", function () {
        _this.onDeleteClicked();
      });
      this.constructor.container.append(template);
      return template;
    }
  }, {
    key: "onDeleteClicked",
    value: function onDeleteClicked() {
      this.constructor.removeByID(this.id);
    }
  }], [{
    key: "clearAll",
    value: function clearAll() {
      var _iterator = _createForOfIteratorHelper(PageData.cache),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var component = _step.value;
          component.dom.remove();
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
      PageData.cache = [];
    }
  }, {
    key: "removeByID",
    value: function removeByID(id) {
      var _iterator2 = _createForOfIteratorHelper(PageData.cache.entries()),
        _step2;
      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var _step2$value = _slicedToArray(_step2.value, 2),
            index = _step2$value[0],
            component = _step2$value[1];
          if (component.id === id) {
            PageData.cache.splice(index, 1);

            // Find it in the component.pageComponent.pageDatas too
            var _iterator3 = _createForOfIteratorHelper(component.pageComponent.pageDatas.entries()),
              _step3;
            try {
              for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
                var _step3$value = _slicedToArray(_step3.value, 2),
                  index2 = _step3$value[0],
                  pageDatasComponent = _step3$value[1];
                if (pageDatasComponent.id === id) {
                  component.pageComponent.pageDatas.splice(index2, 1);
                  break;
                }
              }
            } catch (err) {
              _iterator3.e(err);
            } finally {
              _iterator3.f();
            }
            component.dom.remove();
            break;
          }
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }
    }
  }]);
}();
_defineProperty(PageData, "nextID", 1);
/** @type {PageData[]} */
_defineProperty(PageData, "cache", []);
_defineProperty(PageData, "container", document.querySelector("#page-data-container"));
export default PageData;