function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == typeof h && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator.return && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(typeof e + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, catch: function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(n, t, e, r, o, a, c) { try { var i = n[a](c), u = i.value; } catch (n) { return void e(n); } i.done ? t(u) : Promise.resolve(u).then(r, o); }
function _asyncToGenerator(n) { return function () { var t = this, e = arguments; return new Promise(function (r, o) { var a = n.apply(t, e); function _next(n) { asyncGeneratorStep(a, r, o, _next, _throw, "next", n); } function _throw(n) { asyncGeneratorStep(a, r, o, _next, _throw, "throw", n); } _next(void 0); }); }; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
import WindowManager from "../WindowManager.js";
import Endpoints from "../../Endpoints.js";
import ImageManagerState from "../ImageManagerState.js";
import DirectoryImagesFetcher from "../DirectoryImagesFetcher.js";
import SelectionListener from "../SelectionListener.js";
var MainWindow = /*#__PURE__*/function () {
  /**
   * @param {ImageManager} imageManager
   */
  function MainWindow(imageManager) {
    var _this = this;
    _classCallCheck(this, MainWindow);
    /**
     * @type {ImageManager}
     */
    _defineProperty(this, "imageManager", void 0);
    /**
     * @type {HTMLElement}
     */
    _defineProperty(this, "imagePreviewLoader", void 0);
    /**
     * @type {HTMLElement}
     */
    _defineProperty(this, "imagesLoadingContainer", void 0);
    /**
     * @type {HTMLElement}
     */
    _defineProperty(this, "noImagesMessageContainer", void 0);
    this.imageManager = imageManager;
    this.imagePreviewLoader = this.imageManager.container.querySelector(".image-preview-loader");
    this.imagesLoadingContainer = this.imageManager.container.querySelector(".im-images-loading-container");
    this.noImagesMessageContainer = this.imageManager.container.querySelector(".im-no-images-message");
    this.window = document.querySelector("image-manager-window");
    this.windowBody = this.window.querySelector("im-window-body");
    this.windowFolderContents = this.windowBody.querySelector(".folder-contents-container");
    this.dragOverUploadWindow = this.window.querySelector("#im-upload-container");
    this.dragOverEventDepth = 0;
    this.dismissButton = this.window.querySelector(".im-modal-dismiss-button");
    this.isProcessing = false;
    this.dismissButton.addEventListener("click", function () {
      if (!_this.isProcessing) {
        _this.imageManager.windowManager.closeImageManager();
      }
    });
    this.windowFolderContents.addEventListener("dragover", /** @param {DragEvent} e */
    function (e) {
      e.preventDefault();
    });
    this.windowFolderContents.addEventListener("dragenter", /** @param {DragEvent} e */
    function (e) {
      e.preventDefault();
      if (!_this.imageManager.imageManagerState.isDraggingComponent) {
        ++_this.dragOverEventDepth;
        _this.onWindowBodyFolderContentsDragEnter(e);
      }
    });
    this.windowFolderContents.addEventListener("dragleave", /** @param {DragEvent} e */
    function (e) {
      e.preventDefault();
      if (!_this.imageManager.imageManagerState.isDraggingComponent) {
        --_this.dragOverEventDepth;
        if (_this.dragOverEventDepth === 0) {
          _this.onWindowBodyFolderContentsDragLeave(e);
        }
      }
    });
    this.dragOverUploadWindow.addEventListener("drop", /** @param {DragEvent} e */
    function (e) {
      e.preventDefault();
      // Reset the event depth
      _this.dragOverEventDepth = 0;
      _this.onUploadWindowDrop(e);
    });
  }

  /**
   * When the image manager's main window body folder contents receives a drag enter event
   * @param {DragEvent} e
   */
  return _createClass(MainWindow, [{
    key: "onWindowBodyFolderContentsDragEnter",
    value: function onWindowBodyFolderContentsDragEnter(e) {
      this.showUploadWindow();
    }

    /**
     * When the image manager's main window body folder contents has had the drag operation leave the target zone
     * @param {DragEvent} e
     */
  }, {
    key: "onWindowBodyFolderContentsDragLeave",
    value: function onWindowBodyFolderContentsDragLeave(e) {
      this.hideUploadWindow();
    }

    /**
     * When a drop event fires on the upload window
     * @param {DragEvent} e
     */
  }, {
    key: "onUploadWindowDrop",
    value: (function () {
      var _onUploadWindowDrop = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee(e) {
        var htmlUpload, domParser, htmlDoc, img, source, files, errors;
        return _regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              this.isProcessing = true;

              // Check if the user is dragging an image from somewhere else
              htmlUpload = e.dataTransfer.getData("text/html");
              if (!(htmlUpload !== null)) {
                _context.next = 21;
                break;
              }
              if (!(htmlUpload.trim() !== "")) {
                _context.next = 21;
                break;
              }
              domParser = new DOMParser();
              htmlDoc = domParser.parseFromString(htmlUpload, 'text/html');
              img = htmlDoc.querySelector("img");
              if (!(img !== null)) {
                _context.next = 21;
                break;
              }
              source = img.getAttribute("src");
              if (!(source !== null)) {
                _context.next = 21;
                break;
              }
              if (!(source.trim() !== "")) {
                _context.next = 21;
                break;
              }
              // It is an HTML image upload

              // Show the uploading components
              this.showUploadingInProgressElements();
              _context.next = 14;
              return this.uploadImageBySource(source);
            case 14:
              // Make sure to return here to not process other if conditions
              // Reload the images location
              this.imageManager.directoryImagesFetcher.setDirectory(this.imageManager.imageManagerState.currentDirectory);
              _context.next = 17;
              return this.imageManager.directoryImagesFetcher.fetchAndRender();
            case 17:
              this.imageManager.metaDataPane.hidePreview();
              this.imageManager.metaDataPane.hideImageData();
              this.hideUploadWindow();
              return _context.abrupt("return");
            case 21:
              // Probably not an HTML image upload if gotten here.
              // Check for file transfers
              files = e.dataTransfer.files;
              if (!(files.length > 0)) {
                _context.next = 31;
                break;
              }
              _context.next = 25;
              return this.uploadListOfFiles(files);
            case 25:
              errors = _context.sent;
              // Set processing to false. refreshCurrentLocation will set it back to true
              this.isProcessing = false;

              // All uploads are finished
              _context.next = 29;
              return this.refreshCurrentLocation();
            case 29:
              this.hideUploadWindow();
              if (errors.length > 0) {
                alert("There were upload errors. Check the developer console.");
                console.log("--- Upload errors ---");
                console.log(errors);
              }
            case 31:
              this.isProcessing = false;
            case 32:
            case "end":
              return _context.stop();
          }
        }, _callee, this);
      }));
      function onUploadWindowDrop(_x) {
        return _onUploadWindowDrop.apply(this, arguments);
      }
      return onUploadWindowDrop;
    }()
    /**
     * Refreshes the current location
     */
    )
  }, {
    key: "refreshCurrentLocation",
    value: (function () {
      var _refreshCurrentLocation = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee2() {
        return _regeneratorRuntime().wrap(function _callee2$(_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              if (!this.isProcessing) {
                _context2.next = 2;
                break;
              }
              return _context2.abrupt("return");
            case 2:
              // Clear the selection
              this.imageManager.selectionListener.clearImageComponentSelection();
              this.isProcessing = true;
              this.imageManager.directoryImagesFetcher.setDirectory(this.imageManager.imageManagerState.currentDirectory);
              _context2.next = 7;
              return this.imageManager.directoryImagesFetcher.fetchAndRender();
            case 7:
              this.imageManager.metaDataPane.hidePreview();
              this.imageManager.metaDataPane.hideImageData();
              this.isProcessing = false;
            case 10:
            case "end":
              return _context2.stop();
          }
        }, _callee2, this);
      }));
      function refreshCurrentLocation() {
        return _refreshCurrentLocation.apply(this, arguments);
      }
      return refreshCurrentLocation;
    }()
    /**
     * Uploads a list of files
     * @param {FileList} files
     * @return {Promise<array>}
     */
    )
  }, {
    key: "uploadListOfFiles",
    value: (function () {
      var _uploadListOfFiles = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee4(files) {
        var _this2 = this;
        var finishedUploadSpan, filesUploaded, errors, _iterator, _step, _loop;
        return _regeneratorRuntime().wrap(function _callee4$(_context5) {
          while (1) switch (_context5.prev = _context5.next) {
            case 0:
              finishedUploadSpan = this.dragOverUploadWindow.querySelector("#im-finished-upload-number");
              this.dragOverUploadWindow.querySelector("#im-in-queue-upload-number").textContent = String(files.length);
              finishedUploadSpan.textContent = "0";
              filesUploaded = 0;
              errors = [];
              this.showUploadingInProgressElements();
              _iterator = _createForOfIteratorHelper(files);
              _context5.prev = 7;
              _loop = /*#__PURE__*/_regeneratorRuntime().mark(function _loop() {
                var file, thisPromise;
                return _regeneratorRuntime().wrap(function _loop$(_context4) {
                  while (1) switch (_context4.prev = _context4.next) {
                    case 0:
                      file = _step.value;
                      thisPromise = new Promise(/*#__PURE__*/function () {
                        var _ref = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee3(resolve) {
                          return _regeneratorRuntime().wrap(function _callee3$(_context3) {
                            while (1) switch (_context3.prev = _context3.next) {
                              case 0:
                                _context3.prev = 0;
                                _context3.next = 3;
                                return _this2.uploadBinaryImage(file.name, file);
                              case 3:
                                _context3.next = 8;
                                break;
                              case 5:
                                _context3.prev = 5;
                                _context3.t0 = _context3["catch"](0);
                                errors.push(_context3.t0);
                              case 8:
                                resolve();
                              case 9:
                              case "end":
                                return _context3.stop();
                            }
                          }, _callee3, null, [[0, 5]]);
                        }));
                        return function (_x3) {
                          return _ref.apply(this, arguments);
                        };
                      }());
                      _context4.next = 4;
                      return thisPromise;
                    case 4:
                      ++filesUploaded;
                      finishedUploadSpan.textContent = String(filesUploaded);
                    case 6:
                    case "end":
                      return _context4.stop();
                  }
                }, _loop);
              });
              _iterator.s();
            case 10:
              if ((_step = _iterator.n()).done) {
                _context5.next = 14;
                break;
              }
              return _context5.delegateYield(_loop(), "t0", 12);
            case 12:
              _context5.next = 10;
              break;
            case 14:
              _context5.next = 19;
              break;
            case 16:
              _context5.prev = 16;
              _context5.t1 = _context5["catch"](7);
              _iterator.e(_context5.t1);
            case 19:
              _context5.prev = 19;
              _iterator.f();
              return _context5.finish(19);
            case 22:
              return _context5.abrupt("return", errors);
            case 23:
            case "end":
              return _context5.stop();
          }
        }, _callee4, this, [[7, 16, 19, 22]]);
      }));
      function uploadListOfFiles(_x2) {
        return _uploadListOfFiles.apply(this, arguments);
      }
      return uploadListOfFiles;
    }()
    /**
     * Uploads an image by its remote URL
     * @param {string} source Remote URL
     */
    )
  }, {
    key: "uploadImageBySource",
    value: (function () {
      var _uploadImageBySource = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee5(source) {
        var fData, response, data;
        return _regeneratorRuntime().wrap(function _callee5$(_context6) {
          while (1) switch (_context6.prev = _context6.next) {
            case 0:
              fData = new FormData();
              fData.set("to-directory", this.imageManager.imageManagerState.currentDirectory);
              fData.set("image-source", source);
              _context6.next = 5;
              return fetch("/uplift/image-manager/upload-image-by-url-source", {
                credentials: "same-origin",
                body: fData,
                cache: "no-cache",
                method: "post"
              });
            case 5:
              response = _context6.sent;
              if (!(response.status === 200)) {
                _context6.next = 16;
                break;
              }
              _context6.next = 9;
              return response.json();
            case 9:
              data = _context6.sent;
              if (!(data.status === 1)) {
                _context6.next = 13;
                break;
              }
              _context6.next = 14;
              break;
            case 13:
              throw data.error;
            case 14:
              _context6.next = 17;
              break;
            case 16:
              throw "Unhandled server error.";
            case 17:
            case "end":
              return _context6.stop();
          }
        }, _callee5, this);
      }));
      function uploadImageBySource(_x4) {
        return _uploadImageBySource.apply(this, arguments);
      }
      return uploadImageBySource;
    }()
    /**
     * Uploads a binary string to the upload image file endpoint
     * @param {string} fileName
     * @param {Blob} file
     */
    )
  }, {
    key: "uploadBinaryImage",
    value: (function () {
      var _uploadBinaryImage = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee6(fileName, file) {
        var fData, response, data;
        return _regeneratorRuntime().wrap(function _callee6$(_context7) {
          while (1) switch (_context7.prev = _context7.next) {
            case 0:
              fData = new FormData();
              fData.set("to-directory", this.imageManager.imageManagerState.currentDirectory);
              fData.set("file-binary", file, fileName);
              _context7.next = 5;
              return fetch("/uplift/image-manager/upload-image-file", {
                credentials: "same-origin",
                body: fData,
                cache: "no-cache",
                method: "post"
              });
            case 5:
              response = _context7.sent;
              if (!(response.status === 200)) {
                _context7.next = 16;
                break;
              }
              _context7.next = 9;
              return response.json();
            case 9:
              data = _context7.sent;
              if (!(data.status === 1)) {
                _context7.next = 13;
                break;
              }
              _context7.next = 14;
              break;
            case 13:
              throw data.error;
            case 14:
              _context7.next = 17;
              break;
            case 16:
              throw "Unhandled server error.";
            case 17:
            case "end":
              return _context7.stop();
          }
        }, _callee6, this);
      }));
      function uploadBinaryImage(_x5, _x6) {
        return _uploadBinaryImage.apply(this, arguments);
      }
      return uploadBinaryImage;
    }()
    /**
     * Shows the necessary elements in the upload window to display to the user that an upload is in progress
     */
    )
  }, {
    key: "showUploadingInProgressElements",
    value: function showUploadingInProgressElements() {
      this.dragOverUploadWindow.querySelector("#im-finished-upload-number").textContent = "0";
      this.dragOverUploadWindow.querySelector("#im-uploading-spinner").style.display = "block";
      this.dragOverUploadWindow.querySelector(".im-upload-icon-container").style.display = "none";
      this.dragOverUploadWindow.querySelector("#im-upload-before-drop").style.display = "none";
      this.dragOverUploadWindow.querySelector("#im-upload-after-drop").style.display = "block";
    }

    /**
     * Shows the upload window
     */
  }, {
    key: "showUploadWindow",
    value: function showUploadWindow() {
      this.dragOverUploadWindow.querySelector("#im-uploading-spinner").style.display = "none";
      this.dragOverUploadWindow.querySelector(".im-upload-icon-container").style.display = "block";
      this.dragOverUploadWindow.querySelector("#im-upload-before-drop").style.display = "block";
      this.dragOverUploadWindow.querySelector("#im-upload-after-drop").style.display = "none";
      this.dragOverUploadWindow.style.display = "flex";
    }
    /**
     * Hides the upload window
     */
  }, {
    key: "hideUploadWindow",
    value: function hideUploadWindow() {
      this.dragOverUploadWindow.style.display = "none";
    }

    /**
     * Shows the spinning loader in the image data right-hand panel.
     */
  }, {
    key: "showImagePreviewLoader",
    value: function showImagePreviewLoader() {
      this.imagePreviewLoader.style.display = null;
    }

    /**
     * Hide the spinning loader in the image data right-hand panel.
     */
  }, {
    key: "hideImagePreviewLoader",
    value: function hideImagePreviewLoader() {
      this.imagePreviewLoader.style.display = "none";
    }

    /**
     * Shows the overlay that display a spinner and text representing images are populating/loading in.
     */
  }, {
    key: "showImagesLoading",
    value: function showImagesLoading() {
      this.imagesLoadingContainer.style.display = null;
    }

    /**
     * Hides the overlay that display a spinner and text representing images are populating/loading in.
     */
  }, {
    key: "hideImagesLoading",
    value: function hideImagesLoading() {
      this.imagesLoadingContainer.style.display = "none";
    }

    /**
     * Shows a message displaying no images in this directory.
     */
  }, {
    key: "showNoImagesMessage",
    value: function showNoImagesMessage() {
      this.noImagesMessageContainer.style.display = null;
    }

    /**
     * Hides a message displaying no images in this directory.
     */
  }, {
    key: "hideNoImagesMessage",
    value: function hideNoImagesMessage() {
      this.noImagesMessageContainer.style.display = "none";
    }
  }]);
}();
export default MainWindow;