function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == typeof h && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator.return && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(typeof e + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, catch: function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(n, t, e, r, o, a, c) { try { var i = n[a](c), u = i.value; } catch (n) { return void e(n); } i.done ? t(u) : Promise.resolve(u).then(r, o); }
function _asyncToGenerator(n) { return function () { var t = this, e = arguments; return new Promise(function (r, o) { var a = n.apply(t, e); function _next(n) { asyncGeneratorStep(a, r, o, _next, _throw, "next", n); } function _throw(n) { asyncGeneratorStep(a, r, o, _next, _throw, "throw", n); } _next(void 0); }); }; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
import WindowManager from "../WindowManager.js";
import DirectoryImagesFetcher from "../DirectoryImagesFetcher.js";
import ImageManagerState from "../ImageManagerState.js";
import Scheduler from "../../utils/Scheduler.js";
var CropWindow = /*#__PURE__*/function () {
  function CropWindow(imageManager) {
    var _this = this;
    _classCallCheck(this, CropWindow);
    /**
     * @type {ImageManager}
     */
    _defineProperty(this, "imageManager", void 0);
    this.imageManager = imageManager;
    this.window = this.imageManager.container.querySelector(".im-crop-window");
    this.guidelinesBackground = this.window.querySelector(".crop-guidelines-background");
    this.guidelinesContainer = this.window.querySelector(".crop-guidelines-container");
    this.dismissButton = this.window.querySelector(".im-modal-dismiss-button");
    this.form = this.window.querySelector(".im-crop-fields");
    this.formSubmitButton = this.window.querySelector(".im-crop-fields-submit-button");
    this.previewContainer = this.window.querySelector(".im-crop-preview-container");
    this.previewImage = this.window.querySelector(".im-crop-preview-image");
    this.spinner = this.window.querySelector(".im-crop-loading-spinner");
    this.imageFilePathInput = this.window.querySelector("[name=\"image-file-path\"]");
    this.ratioXInput = this.window.querySelector("[name=\"ratio-x\"]");
    this.ratioYInput = this.window.querySelector("[name=\"ratio-y\"]");
    this.handleButtons = {
      topLeft: this.window.querySelector(".crop-guideline-top-left"),
      topRight: this.window.querySelector(".crop-guideline-top-right"),
      bottomRight: this.window.querySelector(".crop-guideline-bottom-right"),
      bottomLeft: this.window.querySelector(".crop-guideline-bottom-left")
    };

    /**
     * The original width of the image being cropped
     * @type {?number}
     */
    this.imageOriginalWidth = null;

    /**
     * The original height of the image being cropped
     * @type {?number}
     */
    this.imageOriginalHeight = null;

    /**
     * If the mouse is currently held down on a handle button
     * @type {boolean}
     */
    this.isMouseDownOnHandleButton = false;

    /**
     * If the mouse is currently held down on the inner part of the
     * grid guidelines container and not a button. Used to move the guidelines container
     * itself.
     * @type {boolean}
     */
    this.isMouseDownOnGuidelinesContainer = false;

    /**
     * The current handle button being dragged
     * @type {HTMLButtonElement}
     */
    this.currentlyDraggedHandleButton = null;

    /**
     * The last mouse position recorded. This is populated upon mouse down
     * on a handle button or the guidelines container
     */
    this.lastRecordedMousePosition = {
      x: null,
      y: null
    };

    /** @type {boolean} Flag for when the form is submitting and being processed */
    this.isProcessing = false;

    /**
     * The maximum size, in pixels, the grid guidelines container can be.
     * These will be updated each time a new image is loaded into the crop window
     * @type {{width: number, height: number}}
     */
    this.guidelinesSizeMaximums = {
      width: parseInt(window.getComputedStyle(this.guidelinesBackground).width),
      height: parseInt(window.getComputedStyle(this.guidelinesBackground).height)
    };

    /**
     * The crop guideline sizes in percentage. Defaults to 100% because that
     * is what is defined in the stylesheet
     * @type {{width: number, height: number}}
     */
    this.guidelinesSizePercentages = {
      width: 100,
      height: 100
    };
    var _loop = function _loop() {
      var handleButton = _Object$values[_i];
      handleButton.addEventListener("mousedown", function (e) {
        _this.onHandleButtonMouseDown(handleButton, e);
      });
    };
    for (var _i = 0, _Object$values = Object.values(this.handleButtons); _i < _Object$values.length; _i++) {
      _loop();
    }
    this.ratioXInput.addEventListener("input", function () {
      _this.onAspectInputChanged(_this.ratioXInput);
    });
    this.ratioYInput.addEventListener("input", function () {
      _this.onAspectInputChanged(_this.ratioYInput);
    });
    this.formSubmitButton.addEventListener("click", function () {
      _this.onSubmit();
    });
    this.form.addEventListener("submit", function (e) {
      e.preventDefault();
      _this.onSubmit();
    });
    this.guidelinesContainer.addEventListener("mousedown", function (/** @type {MouseEvent} */e) {
      // Is it a div inside the grid guidelines grid elements?
      if (e.target.parentElement.closest(".crop-guidelines-grid") !== null) {
        _this.lastRecordedMousePosition.x = e.pageX;
        _this.lastRecordedMousePosition.y = e.pageY;
        _this.isMouseDownOnGuidelinesContainer = true;
      }
    });
    this.dismissButton.addEventListener("click", function () {
      if (!_this.isProcessing) {
        _this.imageManager.windowManager.show(WindowManager.WINDOWS.MAIN);
      }
    });

    // Event to reset mouse down flags
    window.addEventListener("mouseup", function () {
      if (_this.isMouseDownOnHandleButton) {
        _this.isMouseDownOnHandleButton = false;
      }
      if (_this.isMouseDownOnGuidelinesContainer) {
        _this.isMouseDownOnGuidelinesContainer = false;
      }
    });
    window.addEventListener("mousemove", function (e) {
      if (_this.isMouseDownOnHandleButton) {
        _this.onHandleButtonDragged(_this.currentlyDraggedHandleButton, e);
      } else if (_this.isMouseDownOnGuidelinesContainer) {
        _this.onGuidelinesContainerDragged(e);
      }
    });
  }

  /**
   * When the crop form is submitted
   */
  return _createClass(CropWindow, [{
    key: "onSubmit",
    value: (function () {
      var _onSubmit = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
        var computedStylesForPreviewImage, computedStylesForGuidelines, previewImageWidth, previewImageHeight, guidelineWidth, guidelineHeight, topX, topY, topXPercentage, topYPercentage, bottomXPercentage, bottomYPercentage, realTopX, realTopY, realBottomX, realBottomY, fData, response, data, imageDirectoryFetcher;
        return _regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              if (!this.isProcessing) {
                _context.next = 2;
                break;
              }
              return _context.abrupt("return");
            case 2:
              this.isProcessing = true;

              // Properly fill in the input fields for the topX, topY, bottomX, bottomY
              // corner locations

              // Fetch the computer style of the preview image to determine
              // the relative crop location if the image's actual dimensions are larger
              // than what can be shown in the preview
              computedStylesForPreviewImage = window.getComputedStyle(this.previewImage);
              computedStylesForGuidelines = window.getComputedStyle(this.guidelinesContainer);
              previewImageWidth = parseFloat(computedStylesForPreviewImage.width);
              previewImageHeight = parseFloat(computedStylesForPreviewImage.height);
              guidelineWidth = parseFloat(computedStylesForGuidelines.width);
              guidelineHeight = parseFloat(computedStylesForGuidelines.height);
              topX = parseFloat(computedStylesForGuidelines.left);
              topY = parseFloat(computedStylesForGuidelines.top);
              topXPercentage = topX / previewImageWidth;
              topYPercentage = topY / previewImageHeight;
              bottomXPercentage = (topX + guidelineWidth) / previewImageWidth;
              bottomYPercentage = (topY + guidelineHeight) / previewImageHeight; // Get the locations of the topX,topY,bottomX,bottomY on the image original size
              realTopX = topXPercentage * this.imageOriginalWidth;
              realTopY = topYPercentage * this.imageOriginalHeight;
              realBottomX = bottomXPercentage * this.imageOriginalWidth;
              realBottomY = bottomYPercentage * this.imageOriginalHeight;
              this.previewContainer.style.display = "none";
              this.spinner.style.display = "block";
              fData = new FormData(this.form);
              fData.set("top-x", String(Math.round(realTopX)));
              fData.set("top-y", String(Math.round(realTopY)));
              fData.set("bottom-x", String(Math.round(realBottomX)));
              fData.set("bottom-y", String(Math.round(realBottomY)));
              _context.next = 28;
              return fetch("/uplift/image-manager/crop-image", {
                credentials: "same-origin",
                cache: "no-cache",
                body: fData,
                method: "patch"
              });
            case 28:
              response = _context.sent;
              if (!(response.status === 200)) {
                _context.next = 47;
                break;
              }
              _context.next = 32;
              return response.json();
            case 32:
              data = _context.sent;
              if (!(data.status === 1)) {
                _context.next = 44;
                break;
              }
              // Refresh the images directory to reflect the new data on the resized image
              imageDirectoryFetcher = this.imageManager.directoryImagesFetcher;
              imageDirectoryFetcher.setDirectory(this.imageManager.imageManagerState.currentDirectory);
              _context.next = 38;
              return imageDirectoryFetcher.fetchAndRender();
            case 38:
              this.imageManager.metaDataPane.hidePreview();
              this.imageManager.metaDataPane.hideImageData();
              this.imageManager.windowManager.show(WindowManager.WINDOWS.MAIN);

              // Refresh the cache string that is appended to thumbs in the sidebar preview
              this.imageManager.imageManagerState.currentImageCacheRandomString = String(Math.random());
              _context.next = 45;
              break;
            case 44:
              if (data.status === -1) {
                alert(data.error);
              }
            case 45:
              _context.next = 48;
              break;
            case 47:
              alert("Non-200 OK error. Check the network tab.");
            case 48:
              this.isProcessing = false;
              this.spinner.style.display = "none";
              this.previewContainer.style.display = "inline-block";
            case 51:
            case "end":
              return _context.stop();
          }
        }, _callee, this);
      }));
      function onSubmit() {
        return _onSubmit.apply(this, arguments);
      }
      return onSubmit;
    }()
    /**
     * Function called when this window gets shown
     * @param {string} imageFilePath
     * @param {string} imageURI
     * @param {number} imageOriginalWidth
     * @param {number} imageOriginalHeight
     */
    )
  }, {
    key: "onWindowShown",
    value: function onWindowShown(imageFilePath, imageURI, imageOriginalWidth, imageOriginalHeight) {
      var _this2 = this;
      this.imageFilePathInput.value = imageFilePath;
      this.imageOriginalWidth = imageOriginalWidth;
      this.imageOriginalHeight = imageOriginalHeight;
      var newImageObj = new Image();
      var randomString = Math.random();

      // Wait for the image to load before updating the crop guidelines
      // Otherwise it will not detect the right height and width of the container
      newImageObj.onload = /*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee2() {
        return _regeneratorRuntime().wrap(function _callee2$(_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              _this2.previewImage.setAttribute("src", imageURI + "?no-cache=".concat(randomString));
              _context2.next = 3;
              return Scheduler.wait(50);
            case 3:
              // Update the maximums
              _this2.guidelinesSizeMaximums = {
                width: parseInt(window.getComputedStyle(_this2.guidelinesBackground).width),
                height: parseInt(window.getComputedStyle(_this2.guidelinesBackground).height)
              };
              _this2.updateCropGuideToMatchAspectRatio();
            case 5:
            case "end":
              return _context2.stop();
          }
        }, _callee2);
      }));
      newImageObj.onerror = function () {};
      newImageObj.src = imageURI + "?no-cache=".concat(randomString);
    }

    /**
     * When the mouse has dragged a handle button while holding the LMB down
     * @param {HTMLButtonElement} handleButton
     * @param {MouseEvent} event
     */
  }, {
    key: "onHandleButtonDragged",
    value: function onHandleButtonDragged(handleButton, event) {
      var movementX = event.pageX - this.lastRecordedMousePosition.x;
      var movementY = event.pageY - this.lastRecordedMousePosition.y;
      var aspectRatio = Number(this.ratioYInput.value / this.ratioXInput.value);
      var computedStyles = window.getComputedStyle(this.guidelinesContainer);
      var currentWidth = parseFloat(computedStyles.width);
      var currentHeight = parseFloat(computedStyles.height);
      var currentLeft = parseFloat(computedStyles.left);
      var currentTop = parseFloat(computedStyles.top);
      var newWidth = currentWidth;
      var newLeft = currentLeft;
      var newHeight = currentHeight;
      var newTop = currentTop;

      // Move the top/left properties and resize the guidelines container element
      // based on which handle was dragged and in what direction
      if (handleButton === this.handleButtons.bottomLeft) {
        newWidth = currentWidth - movementX;
        newHeight = currentHeight + movementY;
        var additionalXMovement = 0;
        if (!isNaN(aspectRatio)) {
          if (Math.abs(movementY) > Math.abs(movementX)) {
            // Y axis is dominant. Determine new width
            // Find the width that is closest in aspect ratio to the new height
            var newAspectRatioWidth = newHeight / aspectRatio;
            additionalXMovement += newAspectRatioWidth - newWidth;
            newWidth = newAspectRatioWidth;
          } else {
            newHeight = newWidth * aspectRatio;
          }
        }
        newLeft = currentLeft + movementX - additionalXMovement;
      } else if (handleButton === this.handleButtons.bottomRight) {
        newWidth = currentWidth + movementX;
        newHeight = currentHeight + movementY;
        if (!isNaN(aspectRatio)) {
          if (Math.abs(movementY) > Math.abs(movementX)) {
            newWidth = newHeight / aspectRatio;
          } else {
            newHeight = newWidth * aspectRatio;
          }
        }
      } else if (handleButton === this.handleButtons.topLeft) {
        newWidth = currentWidth - movementX;
        newHeight = currentHeight - movementY;
        var _additionalXMovement = 0;
        var additionalYMovement = 0;
        if (!isNaN(aspectRatio)) {
          if (Math.abs(movementY) > Math.abs(movementX)) {
            // Y axis is dominant. Determine new width
            // Find the width that is closest in aspect ratio to the new height
            var _newAspectRatioWidth = newHeight / aspectRatio;
            _additionalXMovement += _newAspectRatioWidth - newWidth;
            newWidth = _newAspectRatioWidth;
          } else {
            var newAspectRatioHeight = newWidth * aspectRatio;
            additionalYMovement += newAspectRatioHeight - newHeight;
            newHeight = newAspectRatioHeight;
          }
        }
        newLeft = currentLeft + movementX - _additionalXMovement;
        newTop = currentTop + movementY - additionalYMovement;
      } else if (handleButton === this.handleButtons.topRight) {
        newWidth = currentWidth + movementX;
        newHeight = currentHeight - movementY;
        var _additionalYMovement = 0;
        if (!isNaN(aspectRatio)) {
          if (Math.abs(movementY) > Math.abs(movementX)) {
            // Y axis is dominant. Determine new width
            // Find the width that is closest in aspect ratio to the new height
            newWidth = newHeight / aspectRatio;
          } else {
            var _newAspectRatioHeight = newWidth * aspectRatio;
            _additionalYMovement += _newAspectRatioHeight - newHeight;
            newHeight = _newAspectRatioHeight;
          }
        }
        newTop = currentTop + movementY - _additionalYMovement;
      }
      if (newLeft + newWidth > this.guidelinesSizeMaximums.width) {
        // Right side overflow
        newWidth = this.guidelinesSizeMaximums.width - newLeft;
        newHeight = currentHeight;
        newTop = currentTop;
      }
      if (newTop + newHeight > this.guidelinesSizeMaximums.height) {
        // Bottom side overflow
        newHeight = this.guidelinesSizeMaximums.height - newTop;
        newWidth = currentWidth;
        newLeft = currentLeft;
      }
      if (newLeft < 0) {
        // Left side overflow
        newLeft = 0;
        newTop = currentTop;
        newWidth = currentWidth;
        newHeight = currentHeight;
      }
      if (newTop < 0) {
        // Top side overflow
        newTop = 0;
        newLeft = currentLeft;
        newWidth = currentWidth;
        newHeight = currentHeight;
      }
      this.guidelinesContainer.style.width = "".concat(newWidth, "px");
      this.guidelinesContainer.style.height = "".concat(newHeight, "px");
      this.guidelinesContainer.style.left = "".concat(newLeft, "px");
      this.guidelinesContainer.style.top = "".concat(newTop, "px");

      // Update the last recorded mouse position
      this.lastRecordedMousePosition.x = event.pageX;
      this.lastRecordedMousePosition.y = event.pageY;

      // this.checkAndHandleGuidelineOverflow();
    }

    /**
     * Checks for overflow and corrects the overflow of the grid guidelines
     */
  }, {
    key: "checkAndHandleGuidelineOverflow",
    value: function checkAndHandleGuidelineOverflow() {
      var computedStyles = window.getComputedStyle(this.guidelinesContainer);
      // Check for overflow
      // Check if the top-left corner is overflowing
      var topLeftCornerPosition = {
        x: parseFloat(computedStyles.left),
        y: parseFloat(computedStyles.top)
      };
      var bottomRightCornerPosition = {
        x: topLeftCornerPosition.x + parseFloat(computedStyles.width),
        y: topLeftCornerPosition.y + parseFloat(computedStyles.height)
      };

      // Left side overflow
      if (topLeftCornerPosition.x < 0) {
        // Correct the left side overflow
        var difference = Math.abs(topLeftCornerPosition.x);
        this.guidelinesContainer.style.left = "0";
        this.guidelinesContainer.style.width = "".concat(parseFloat(computedStyles.width) + difference, "px");
      }

      // Top side overflow
      if (topLeftCornerPosition.y < 0) {
        var _difference = Math.abs(topLeftCornerPosition.y);
        this.guidelinesContainer.style.top = "0";
        this.guidelinesContainer.style.height = "".concat(parseFloat(computedStyles.height) + _difference, "px");
      }

      // Right side overflow
      if (bottomRightCornerPosition.x > this.guidelinesSizeMaximums.width) {
        if (parseFloat(computedStyles.width) === this.guidelinesSizeMaximums.width) {
          this.guidelinesContainer.style.left = "0";
          this.guidelinesContainer.style.width = "".concat(this.guidelinesSizeMaximums.width, "px");
        } else {
          var _difference2 = Math.abs(bottomRightCornerPosition.x - this.guidelinesSizeMaximums.width);
          this.guidelinesContainer.style.left = "".concat(parseFloat(computedStyles.left) - _difference2, "px");
          this.guidelinesContainer.style.width = "".concat(parseFloat(computedStyles.width) - _difference2, "px");
        }
      }

      // Bottom side overflow
      if (bottomRightCornerPosition.y > this.guidelinesSizeMaximums.height) {
        if (parseFloat(computedStyles.height) === this.guidelinesSizeMaximums.height) {
          this.guidelinesContainer.style.top = "0";
          this.guidelinesContainer.style.height = "".concat(this.guidelinesSizeMaximums.height, "px");
        } else {
          var _difference3 = Math.abs(bottomRightCornerPosition.y - this.guidelinesSizeMaximums.height);
          this.guidelinesContainer.style.top = "".concat(parseFloat(computedStyles.top) - _difference3, "px");
          this.guidelinesContainer.style.height = "".concat(parseFloat(computedStyles.height) - _difference3, "px");
        }
      }
    }

    /**
     *
     * @param {HTMLButtonElement} handleButton
     * @param {MouseEvent} event
     */
  }, {
    key: "onHandleButtonMouseDown",
    value: function onHandleButtonMouseDown(handleButton, event) {
      this.isMouseDownOnHandleButton = true;
      this.currentlyDraggedHandleButton = handleButton;
      this.lastRecordedMousePosition.x = event.pageX;
      this.lastRecordedMousePosition.y = event.pageY;
    }

    /**
     * Updates the crop grid outline to match the aspect ratio set by the inputs
     */
  }, {
    key: "updateCropGuideToMatchAspectRatio",
    value: function updateCropGuideToMatchAspectRatio() {
      var ratioX = parseInt(this.ratioXInput.value);
      var ratioY = parseInt(this.ratioYInput.value);

      // Get the maximum height that can be considered for the grid outline.
      // This is based on where the box was last manually dragged
      var maxWidthToConsider = this.guidelinesSizeMaximums.width * (this.guidelinesSizePercentages.width / 100);
      var maxHeightToConsider = this.guidelinesSizeMaximums.height * (this.guidelinesSizePercentages.width / 100);
      if (!isNaN(ratioX) && !isNaN(ratioY)) {
        var currentAspectRatioRounded = (maxHeightToConsider / maxWidthToConsider).toFixed(2);
        var desiredAspectRatioRounded = (ratioY / ratioX).toFixed(2);
        if (currentAspectRatioRounded !== desiredAspectRatioRounded) {
          var newHeight = desiredAspectRatioRounded * maxWidthToConsider;
          if (newHeight > maxHeightToConsider) {
            // Adjust the width instead
            var newWidth = maxHeightToConsider / desiredAspectRatioRounded;
            this.guidelinesContainer.style.width = "".concat(newWidth, "px");
            this.guidelinesContainer.style.height = null;
          } else {
            this.guidelinesContainer.style.height = "".concat(newHeight, "px");
            this.guidelinesContainer.style.width = null;
          }
        }
      }
    }

    /**
     * When any aspect ratio input boxes are changed
     * @param {HTMLInputElement} inputElementChanged
     */
  }, {
    key: "onAspectInputChanged",
    value: function onAspectInputChanged(inputElementChanged) {
      this.updateCropGuideToMatchAspectRatio();
    }

    /**
     * When the guidelines container itself is dragged.
     * @param {MouseEvent} event
     */
  }, {
    key: "onGuidelinesContainerDragged",
    value: function onGuidelinesContainerDragged(event) {
      var movementX = event.pageX - this.lastRecordedMousePosition.x;
      var movementY = event.pageY - this.lastRecordedMousePosition.y;
      var computedStyles = window.getComputedStyle(this.guidelinesContainer);
      var currentLeft = parseFloat(computedStyles.left);
      var currentTop = parseFloat(computedStyles.top);
      var width = parseFloat(computedStyles.width);
      var height = parseFloat(computedStyles.height);
      var newLeft = currentLeft + movementX;
      var newTop = currentTop + movementY;
      if (newLeft < 0) {
        newLeft = 0;
      }
      if (newTop < 0) {
        newTop = 0;
      }
      if (width + newLeft > this.guidelinesSizeMaximums.width) {
        newLeft -= newLeft + width - this.guidelinesSizeMaximums.width;
      }
      if (height + newTop > this.guidelinesSizeMaximums.height) {
        newTop -= newTop + height - this.guidelinesSizeMaximums.height;
      }
      this.guidelinesContainer.style.left = "".concat(newLeft, "px");
      this.guidelinesContainer.style.top = "".concat(newTop, "px");

      // Update the last recorded mouse position
      this.lastRecordedMousePosition.x = event.pageX;
      this.lastRecordedMousePosition.y = event.pageY;
    }
  }]);
}();
export default CropWindow;