function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == typeof h && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator.return && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(typeof e + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, catch: function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(n, t, e, r, o, a, c) { try { var i = n[a](c), u = i.value; } catch (n) { return void e(n); } i.done ? t(u) : Promise.resolve(u).then(r, o); }
function _asyncToGenerator(n) { return function () { var t = this, e = arguments; return new Promise(function (r, o) { var a = n.apply(t, e); function _next(n) { asyncGeneratorStep(a, r, o, _next, _throw, "next", n); } function _throw(n) { asyncGeneratorStep(a, r, o, _next, _throw, "throw", n); } _next(void 0); }); }; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
import ContextMenu from "../../utils/ContextMenu.js";
import WindowManager from "../WindowManager.js";
import Scheduler from "../../utils/Scheduler.js";
var ImageComponent = /*#__PURE__*/function () {
  /**
   * @param {ImageManager} imageManager
   * @param {Object} imageFileData From the backend API
   */
  function ImageComponent(imageManager, imageFileData) {
    _classCallCheck(this, ImageComponent);
    /**
     * @type {ImageManager}
     */
    _defineProperty(this, "imageManager", void 0);
    this.imageManager = imageManager;
    this.container = imageManager.getImageComponentsContainer();
    this._hashIndex = ++ImageComponent.currentImageComponentHashNumber;
    this.fileName = imageFileData.fileName;
    this.fullFilePath = imageFileData.fullFilePath;
    this.fileNameWithoutExtension = imageFileData.fileNameWithoutExtension;
    this.fileSize = imageFileData.fileSize;
    this.fileSizeHumanReadable = imageFileData.fileSizeHumanReadable;
    this.fileExtension = imageFileData.fileExtension.toLowerCase();
    this.thumbURI = "thumbURI" in imageFileData ? imageFileData.thumbURI : null;
    this.uri = imageFileData.uri;
    this.imageWidth = "gdHelper" in imageFileData ? imageFileData.gdHelper.width : null;
    this.imageHeight = "gdHelper" in imageFileData ? imageFileData.gdHelper.height : null;
    this.imageTypePHPGDInteger = "gdHelper" in imageFileData ? imageFileData.gdHelper.imageType : null;
    this.fallbackImage = imageFileData.fallbackImage;

    /**
     * The last time the mouse clicked on this element. Helps to determine double clicks
     * @type {number}
     */
    this.lastMouseClickTime = 0;

    /**
     * The <im-image> element for this component
     * @type {HTMLElement}
     */
    this.dom = null;

    /**
     * Flag for whether a renamed submission is processing
     * @type {boolean}
     */
    this.isRenameProcessing = false;
    ImageComponent.imageComponentDOMLookupHash[this._hashIndex] = this;
  }

  /**
   * Tries to use the image name to create an alt text
   * @return {string}
   */
  return _createClass(ImageComponent, [{
    key: "tryToCreateAlt",
    value: function tryToCreateAlt() {
      var alt = this.fileNameWithoutExtension;
      alt = alt.replace(new RegExp("-", "g"), " ").replace(new RegExp("_", "g"), " ").replace(new RegExp("\\.", "g"), " ").replace(new RegExp("\\+", "g"), " ").replace(new RegExp("\\)", "g"), "").replace(new RegExp("\\(", "g"), "").replace(/\s{2,}/g, " ") // More than 1 space to a single space
      .replace(/[\s\d]+$/, "") // Remove the ending if it's just spaces and numbers
      .trim().toLowerCase();
      return alt.substring(0, 1).toUpperCase() + alt.substring(1);
    }
  }, {
    key: "getDOM",
    value: function getDOM() {
      var _this = this;
      var template = document.createElement("im-image");
      template.setAttribute("tabindex", "0");
      template.setAttribute("draggable", "true");
      template.setAttribute("image-type", this.fileExtension.toLowerCase());

      // Helps find this image component by its DOM
      template.setAttribute("hash-lookup-id", this._hashIndex);
      template.innerHTML = "\n\t\t\t<div class=\"image-rename-container\" style=\"display:none;\">\n\t\t\t\t<form class=\"image-rename-form\">\n\t\t\t\t\t<input type=\"text\" class=\"form-control\" class=\"image-rename-input-field\" value=\"".concat(this.fileNameWithoutExtension, "\">\n\t\t\t\t</form>\n\t\t\t</div>\n\t\t\t<div class=\"image-name-contents\">\n\t\t\t\t<i class=\"bi bi-image-fill\" image-type=\"").concat(this.fileExtension.toLowerCase(), "\"></i>\n\t\t\t\t<span class=\"image-full-file-name\">\n\t\t\t\t\t<span class=\"image-file-name\">").concat(this.fileNameWithoutExtension, "</span>.<span class=\"image-file-extension\">").concat(this.fileExtension, "</span>\n\t\t\t\t</span>\n\t\t\t</div>\n\t\t\t<div class=\"image-type-container\">\n\t\t\t\t<span class=\"image-type\">").concat(this.fileExtension.toUpperCase(), "</span>\n\t\t\t</div>\n\t\t\t<div class=\"file-size-container\">\n\t\t\t\t<span class=\"image-file-size\">").concat(this.fileSizeHumanReadable, "</span>\n\t\t\t</div>\n\t\t");
      template.addEventListener("click", function (e) {
        _this.onClicked(e);
      });
      template.addEventListener("focusin", /*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
        return _regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              _this.imageManager.metaDataPane.hideImageData();
              _this.imageManager.metaDataPane.hidePreview(_this.thumbURI);
              _this.imageManager.windowManager.mainWindow.showImagePreviewLoader();
              _context.next = 5;
              return _this.loadFileDimensions();
            case 5:
              _context.next = 7;
              return Scheduler.wait(50);
            case 7:
              _this.imageManager.windowManager.mainWindow.hideImagePreviewLoader();

              // Not all images have thumbs - thumbs don't have thumbs, for instance
              if (_this.thumbURI !== null) {
                _this.imageManager.metaDataPane.showPreview(_this.thumbURI);
              } else {
                _this.imageManager.metaDataPane.showPreview(_this.uri);
              }
              _this.imageManager.metaDataPane.showImageData(_this.fileSizeHumanReadable, _this.fileExtension, _this.imageWidth, _this.imageHeight);
            case 10:
            case "end":
              return _context.stop();
          }
        }, _callee);
      })));
      template.addEventListener("dragstart", function (e) {
        if (_this.isRenameFormShown()) {
          return true;
        } else {
          if (_this.imageManager.imageManagerState.isDraggingComponent === false) {
            // Add to select if it isn't there
            if (!_this.imageManager.selectionListener.isImageComponentInSelection(_this)) {
              _this.imageManager.selectionListener.addImageComponentToSelection(_this);
            }
            _this.imageManager.imageManagerState.isDraggingComponent = true;
            _this.imageManager.imageManagerState.currentlyDraggedImageComponent = _this;
            e.dataTransfer.setData("text/plain", _this.fullFilePath);
            e.dataTransfer.setData("cms/droptype", "image");
          }
        }
      });
      template.addEventListener("contextmenu", function (e) {
        // Check if the rename field is currently open
        if (_this.isRenameFormShown()) {
          return;
        }
        e.preventDefault();
        e.stopPropagation();
        _this.onContextMenu(e);
      });
      this.dom = template;
      this.hookEvents();
      return template;
    }

    /**
     * @date 3/16/2023
     * Added to allow image dimensions to not be available when fetching initial image directories. Loading the
     * dimensions was causing significant load times.
     *
     * Fetches the image dimensions from the server and loads them into the imageWidth and imageHeight properties,
     * if they are currently null and the image extension is not SVG.
     */
  }, {
    key: "loadFileDimensions",
    value: (function () {
      var _loadFileDimensions = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee2() {
        var urlParams, response, data;
        return _regeneratorRuntime().wrap(function _callee2$(_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              if (!(this.imageWidth === null && this.imageHeight === null && this.fileExtension.toLowerCase() !== "svg")) {
                _context2.next = 17;
                break;
              }
              urlParams = new URLSearchParams();
              urlParams.set("image-path", this.fullFilePath);
              _context2.next = 5;
              return fetch("/uplift/image-manager/get-image-dimensions?".concat(urlParams.toString()), {
                method: "GET",
                cache: "no-cache",
                credentials: "same-origin"
              });
            case 5:
              response = _context2.sent;
              _context2.prev = 6;
              _context2.next = 9;
              return response.json();
            case 9:
              data = _context2.sent;
              _context2.next = 16;
              break;
            case 12:
              _context2.prev = 12;
              _context2.t0 = _context2["catch"](6);
              alert("The server responded with invalid JSON.");
              return _context2.abrupt("return");
            case 16:
              if (data.status === 1) {
                this.imageWidth = data.width;
                this.imageHeight = data.height;
              } else if (data.status === -1) {}
            case 17:
            case "end":
              return _context2.stop();
          }
        }, _callee2, this, [[6, 12]]);
      }));
      function loadFileDimensions() {
        return _loadFileDimensions.apply(this, arguments);
      }
      return loadFileDimensions;
    }()
    /**
     * When this image component is clicked
     * @param {PointerEvent} e
     */
    )
  }, {
    key: "onClicked",
    value: function onClicked(e) {
      var now = new Date().getTime();
      var differenceSinceLastClick = now - this.lastMouseClickTime;
      var selectionListener = this.imageManager.selectionListener;
      if (differenceSinceLastClick > 400 && differenceSinceLastClick < 700) {
        if (!this.isRenameFormShown()) {
          selectionListener.clearImageComponentSelection();
          this.toggleRenameField();
        }
      } else {
        if (selectionListener.hasImageComponentsSelected()) {
          // Add or overwrite?
          if (e.ctrlKey) {
            if (selectionListener.isImageComponentInSelection(this)) {
              selectionListener.removeImageComponentFromSelection(this);
            } else {
              selectionListener.addImageComponentToSelection(this);
            }
          } else if (e.shiftKey) {
            selectionListener.addImageComponentsToSelectionFromRange(selectionListener.currentImageComponentSelection[0], this);
          } else {
            // Neither, clear selection then add this one
            selectionListener.clearImageComponentSelection();
            selectionListener.addImageComponentToSelection(this);
          }
        } else {
          selectionListener.addImageComponentToSelection(this);
        }
        if (differenceSinceLastClick <= 400) {
          // Double click
          this.imageManager.imagesChosenPromiseResolveFunction(selectionListener.currentImageComponentSelection);
        }
      }
      this.lastMouseClickTime = now;
    }

    /**
     * When the context menu is requested on this image component
     * @param {MouseEvent} e
     */
  }, {
    key: "onContextMenu",
    value: function onContextMenu(e) {
      var selectionListener = this.imageManager.selectionListener;
      if (selectionListener.hasImageComponentsSelected()) {
        if (selectionListener.currentImageComponentSelection.length === 1) {
          // Only one
          this.onSingleSelectionContextMenu(e);
        } else {
          if (selectionListener.isImageComponentInSelection(this)) {
            this.onMultipleSelectionContextMenu(e);
          } else {
            // This function will clear the selection and select this component
            this.onSingleSelectionContextMenu(e);
          }
        }
      } else {
        this.onSingleSelectionContextMenu(e);
      }
    }

    /**
     * When a context menu is requested and this is the only ImageComponent
     * in the selection
     * @param {MouseEvent} e
     */
  }, {
    key: "onSingleSelectionContextMenu",
    value: function onSingleSelectionContextMenu(e) {
      var _this2 = this;
      var selectionListener = this.imageManager.selectionListener;

      // Clear selection if there is one and select this
      selectionListener.clearImageComponentSelection();
      selectionListener.addImageComponentToSelection(this);
      var cm = new ContextMenu(e.pageX, e.pageY);
      var renameButton = cm.addButton("\n\t\t\t\t<div class=\"cm-img-component-button-splitter\">\n\t\t\t\t\t<i class=\"bi bi-input-cursor-text\"></i>\n\t\t\t\t\t<span>Rename</span>\n\t\t\t\t</div>\n\t\t\t");
      cm.addSeparator();
      if (this.fileExtension !== "svg") {
        var resizeButton = cm.addButton("\n\t\t\t\t<div class=\"cm-img-component-button-splitter\">\n\t\t\t\t\t<i class=\"bi bi-bounding-box\"></i>\n\t\t\t\t\t<span>Resize</span>\n\t\t\t\t</div>\n\t\t\t");
        resizeButton.addEventListener("click", function () {
          cm.cleanup();
          _this2.imageManager.windowManager.show(WindowManager.WINDOWS.RESIZE);
          _this2.imageManager.windowManager.resizeWindow.onWindowShown(_this2.fullFilePath, _this2.uri, _this2.imageWidth, _this2.imageHeight);
        });
        var cropButton = cm.addButton("\n\t\t\t\t<div class=\"cm-img-component-button-splitter\">\n\t\t\t\t\t<i class=\"bi bi-person-bounding-box\"></i>\n\t\t\t\t\t<span>Crop</span>\n\t\t\t\t</div>\n\t\t\t");
        cropButton.addEventListener("click", function () {
          cm.cleanup();
          _this2.imageManager.windowManager.show(WindowManager.WINDOWS.CROP);
          _this2.imageManager.windowManager.cropWindow.onWindowShown(_this2.fullFilePath, _this2.uri, _this2.imageWidth, _this2.imageHeight);
        });
        cm.addSeparator();
      }
      var cloneButton = cm.addButton("\n\t\t\t<div class=\"cm-img-component-button-splitter\">\n\t\t\t\t<i class=\"bi bi-images\"></i>\n\t\t\t\t<span>Clone</span>\n\t\t\t</div>\n\t\t");
      cloneButton.addEventListener("click", function () {
        cm.cleanup();
        _this2.imageManager.windowManager.show(WindowManager.WINDOWS.CLONE);
        _this2.imageManager.windowManager.cloneWindow.onWindowShown(_this2.fullFilePath, _this2.fileNameWithoutExtension, _this2.fileExtension);
      });
      if (this.fileExtension !== "svg") {
        var regenThumbButton = cm.addButton("\n\t\t\t\t<div class=\"cm-img-component-button-splitter\">\n\t\t\t\t\t<i class=\"bi bi-image-fill\"></i>\n\t\t\t\t\t<span>Regen Thumb</span>\n\t\t\t\t</div>\n\t\t\t");
        regenThumbButton.addEventListener("click", function (e) {
          cm.cleanup();
          _this2.onRegenButtonClicked();
        });
      }
      cm.addSeparator();
      var copyImageURI = cm.addButton("\n\t\t\t<div class=\"cm-img-component-button-splitter\">\n\t\t\t\t<i class=\"bi bi-pin-map-fill\"></i>\n\t\t\t\t<span>Copy URI</span>\n\t\t\t</div>\n\t\t");
      copyImageURI.addEventListener("click", function (e) {
        cm.cleanup();
        _this2.onCopyURIButtonClicked();
      });
      cm.addSeparator();
      var deleteButton = cm.addButton("\n\t\t\t\t<div class=\"cm-img-component-button-splitter\">\n\t\t\t\t\t<i class=\"text-danger bi bi-x-circle-fill\"></i>\n\t\t\t\t\t<span>Delete</span>\n\t\t\t\t</div>\n\t\t\t");
      deleteButton.addEventListener("click", function (e) {
        cm.cleanup();
        _this2.onDeleteButtonClicked();
      });
      renameButton.addEventListener("click", function () {
        cm.cleanup();
        _this2.toggleRenameField();
      });
      cm.render();
    }

    /**
     * When a context menu is requested and this is the only ImageComponent
     * in the selection
     * @param {MouseEvent} e
     */
  }, {
    key: "onMultipleSelectionContextMenu",
    value: function onMultipleSelectionContextMenu(e) {
      var _this3 = this;
      var cm = new ContextMenu(e.pageX, e.pageY);
      var resizeButton = cm.addButton("\n\t\t\t<div class=\"cm-img-component-button-splitter\">\n\t\t\t\t<i class=\"bi bi-bounding-box\"></i>\n\t\t\t\t<span>Resize All</span>\n\t\t\t</div>\n\t\t");
      resizeButton.addEventListener("click", function () {
        cm.cleanup();
        _this3.imageManager.windowManager.show(WindowManager.WINDOWS.RESIZE);
        _this3.imageManager.windowManager.resizeWindow.onWindowShown();
      });
      cm.addSeparator();
      var cloneAndConvertTypesButton = cm.addButton("\n\t\t\t<div class=\"cm-img-component-button-splitter\">\n\t\t\t\t<i class=\"bi bi-images\"></i>\n\t\t\t\t<span>Clone &amp; Convert</span>\n\t\t\t</div>\n\t\t\t");
      cloneAndConvertTypesButton.addEventListener("click", function () {
        cm.cleanup();
        _this3.imageManager.windowManager.show(WindowManager.WINDOWS.CLONE);
        _this3.imageManager.windowManager.cloneWindow.onWindowShown(_this3.fullFilePath, _this3.fileNameWithoutExtension, _this3.fileExtension);
      });
      var regenThumbButton = cm.addButton("\n\t\t\t\t<div class=\"cm-img-component-button-splitter\">\n\t\t\t\t\t<i class=\"bi bi-image-fill\"></i>\n\t\t\t\t\t<span>Regen Thumbs</span>\n\t\t\t\t</div>\n\t\t\t");
      regenThumbButton.addEventListener("click", function (e) {
        cm.cleanup();
        _this3.onRegenButtonClicked();
      });
      cm.addSeparator();
      var deleteButton = cm.addButton("\n\t\t\t<div class=\"cm-img-component-button-splitter\">\n\t\t\t\t<i class=\"text-danger bi bi-x-circle-fill\"></i>\n\t\t\t\t<span>Delete All</span>\n\t\t\t</div>\n\t\t");
      deleteButton.addEventListener("click", function (e) {
        cm.cleanup();
        _this3.onDeleteButtonClicked();
      });
      cm.render();
    }

    /**
     * Submits a thumb regeneration request for this image component
     */
  }, {
    key: "onRegenButtonClicked",
    value: (function () {
      var _onRegenButtonClicked = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee3() {
        var _iterator, _step, component, fData, response, data;
        return _regeneratorRuntime().wrap(function _callee3$(_context3) {
          while (1) switch (_context3.prev = _context3.next) {
            case 0:
              _iterator = _createForOfIteratorHelper(this.imageManager.selectionListener.currentImageComponentSelection);
              _context3.prev = 1;
              _iterator.s();
            case 3:
              if ((_step = _iterator.n()).done) {
                _context3.next = 16;
                break;
              }
              component = _step.value;
              fData = new FormData();
              fData.set("image-path", component.fullFilePath);
              _context3.next = 9;
              return fetch("/uplift/image-manager/regenerate-thumb", {
                credentials: "same-origin",
                cache: "no-cache",
                method: "patch",
                body: fData
              });
            case 9:
              response = _context3.sent;
              _context3.next = 12;
              return response.json();
            case 12:
              data = _context3.sent;
              if (data.status === 1) {}
            case 14:
              _context3.next = 3;
              break;
            case 16:
              _context3.next = 21;
              break;
            case 18:
              _context3.prev = 18;
              _context3.t0 = _context3["catch"](1);
              _iterator.e(_context3.t0);
            case 21:
              _context3.prev = 21;
              _iterator.f();
              return _context3.finish(21);
            case 24:
            case "end":
              return _context3.stop();
          }
        }, _callee3, this, [[1, 18, 21, 24]]);
      }));
      function onRegenButtonClicked() {
        return _onRegenButtonClicked.apply(this, arguments);
      }
      return onRegenButtonClicked;
    }()
    /**
     * Copies the URI to the clipboard
     */
    )
  }, {
    key: "onCopyURIButtonClicked",
    value: (function () {
      var _onCopyURIButtonClicked = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee4() {
        var uriToCopy;
        return _regeneratorRuntime().wrap(function _callee4$(_context4) {
          while (1) switch (_context4.prev = _context4.next) {
            case 0:
              _context4.prev = 0;
              if (navigator.clipboard) {
                _context4.next = 3;
                break;
              }
              throw new Error("Clipboard API not supported.");
            case 3:
              // Replace spaces with %20
              uriToCopy = this.uri.replace(/ /g, "%20"); // Attempt to write text to the clipboard
              _context4.next = 6;
              return navigator.clipboard.writeText(uriToCopy);
            case 6:
              console.log("URI copied to clipboard successfully.");
              _context4.next = 12;
              break;
            case 9:
              _context4.prev = 9;
              _context4.t0 = _context4["catch"](0);
              console.error("Failed to copy URI: ", _context4.t0);
            case 12:
            case "end":
              return _context4.stop();
          }
        }, _callee4, this, [[0, 9]]);
      }));
      function onCopyURIButtonClicked() {
        return _onCopyURIButtonClicked.apply(this, arguments);
      }
      return onCopyURIButtonClicked;
    }()
    /**
     * Submits a request to delete all images in the current selection
     */
    )
  }, {
    key: "onDeleteButtonClicked",
    value: (function () {
      var _onDeleteButtonClicked = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee5() {
        var _iterator2, _step2, component, fData, response, data;
        return _regeneratorRuntime().wrap(function _callee5$(_context5) {
          while (1) switch (_context5.prev = _context5.next) {
            case 0:
              _iterator2 = _createForOfIteratorHelper(this.imageManager.selectionListener.currentImageComponentSelection);
              _context5.prev = 1;
              _iterator2.s();
            case 3:
              if ((_step2 = _iterator2.n()).done) {
                _context5.next = 16;
                break;
              }
              component = _step2.value;
              fData = new FormData();
              fData.set("image-path", component.fullFilePath);
              _context5.next = 9;
              return fetch("/uplift/image-manager/delete-image", {
                credentials: "same-origin",
                cache: "no-cache",
                method: "delete",
                body: fData
              });
            case 9:
              response = _context5.sent;
              _context5.next = 12;
              return response.json();
            case 12:
              data = _context5.sent;
              if (data.status === 1) {
                // Remove the DOM representing this image component
                component.dom.remove();
              }
            case 14:
              _context5.next = 3;
              break;
            case 16:
              _context5.next = 21;
              break;
            case 18:
              _context5.prev = 18;
              _context5.t0 = _context5["catch"](1);
              _iterator2.e(_context5.t0);
            case 21:
              _context5.prev = 21;
              _iterator2.f();
              return _context5.finish(21);
            case 24:
            case "end":
              return _context5.stop();
          }
        }, _callee5, this, [[1, 18, 21, 24]]);
      }));
      function onDeleteButtonClicked() {
        return _onDeleteButtonClicked.apply(this, arguments);
      }
      return onDeleteButtonClicked;
    }()
    /**
     * Hooks necessary events to elements in the component
     */
    )
  }, {
    key: "hookEvents",
    value: function hookEvents() {
      var _this4 = this;
      var renameForm = this.dom.querySelector(".image-rename-form");
      renameForm.addEventListener("submit", function (e) {
        e.preventDefault();
        _this4.submitRenameForm();
      });
      renameForm.querySelector("input").addEventListener("blur", function (e) {
        _this4.submitRenameForm();
      });
      renameForm.querySelector("input").addEventListener("focusout", function (e) {
        _this4.submitRenameForm();
      });
    }

    /**
     * Submits a rename request
     */
  }, {
    key: "submitRenameForm",
    value: (function () {
      var _submitRenameForm = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee6() {
        var renameForm, fData, inputField, newFileNameWithoutExtension, response, data;
        return _regeneratorRuntime().wrap(function _callee6$(_context6) {
          while (1) switch (_context6.prev = _context6.next) {
            case 0:
              if (!this.isRenameProcessing) {
                _context6.next = 2;
                break;
              }
              return _context6.abrupt("return");
            case 2:
              renameForm = this.dom.querySelector(".image-rename-form");
              fData = new FormData();
              inputField = renameForm.querySelector("input");
              newFileNameWithoutExtension = inputField.value.trim();
              fData.set("new-file-name-without-extension", newFileNameWithoutExtension);
              fData.set("file-path", this.fullFilePath);

              // Check if a renaming is actually happening
              if (!(newFileNameWithoutExtension.toLowerCase() === this.fileNameWithoutExtension.toLowerCase())) {
                _context6.next = 11;
                break;
              }
              this.toggleRenameField();
              return _context6.abrupt("return");
            case 11:
              this.isRenameProcessing = true;
              inputField.setAttribute("disabled", "true");
              _context6.next = 15;
              return fetch("/uplift/image-manager/rename-image", {
                credentials: "same-origin",
                cache: "no-cache",
                method: "patch",
                body: fData
              });
            case 15:
              response = _context6.sent;
              if (!(response.status === 200)) {
                _context6.next = 23;
                break;
              }
              _context6.next = 19;
              return response.json();
            case 19:
              data = _context6.sent;
              if (data.status === 1) {
                // Success
                this.renameSuccess(data.newImageFilePath, data.newFileNameWithoutExtension, data.newImageURI, data.newImageThumbURI);
              } else if (data.status === -1) {
                inputField.removeAttribute("disabled");
                this.isRenameProcessing = false;
                alert(data.error);
              }
              _context6.next = 26;
              break;
            case 23:
              inputField.removeAttribute("disabled");
              this.isRenameProcessing = false;
              alert("Non-200 OK response. Check the inspector network tab.");
            case 26:
            case "end":
              return _context6.stop();
          }
        }, _callee6, this);
      }));
      function submitRenameForm() {
        return _submitRenameForm.apply(this, arguments);
      }
      return submitRenameForm;
    }()
    /**
     * Successful image renaming response from the backend
     * @param {string} newImageFilePath
     * @param {string} newImageNameWithoutExtension
     * @param {string} newImageURI
     * @param {string} newImageThumbURI
     */
    )
  }, {
    key: "renameSuccess",
    value: function renameSuccess(newImageFilePath, newImageNameWithoutExtension, newImageURI, newImageThumbURI) {
      this.fileNameWithoutExtension = newImageNameWithoutExtension;
      this.fullFilePath = newImageFilePath;
      this.fileName = "".concat(newImageNameWithoutExtension, ".").concat(this.fileExtension);
      this.uri = newImageURI;
      this.thumbURI = newImageThumbURI;
      this.dom.querySelector(".image-file-name").textContent = newImageNameWithoutExtension;
      this.isRenameProcessing = false;
      this.toggleRenameField();
      var renameForm = this.dom.querySelector(".image-rename-form");
      var inputField = renameForm.querySelector("input");
      inputField.removeAttribute("disabled");
    }

    /**
     * Checks if the image rename field is active
     */
  }, {
    key: "isRenameFormShown",
    value: function isRenameFormShown() {
      return this.dom.querySelector(".image-rename-container").style.display !== "none";
    }

    /**
     * Toggles the image rename field for this component
     */
  }, {
    key: "toggleRenameField",
    value: function toggleRenameField() {
      /** @type {HTMLDivElement} */
      var renameDiv = this.dom.querySelector(".image-rename-container");
      var nameContents = this.dom.querySelector(".image-name-contents");
      if (!this.isRenameFormShown()) {
        this.dom.removeAttribute("draggable");
        nameContents.style.display = "none";
        renameDiv.style.display = "block";
        renameDiv.querySelector("form input").focus();
      } else {
        this.dom.setAttribute("draggable", "true");
        nameContents.style.display = "block";
        renameDiv.style.display = "none";
      }
    }
  }, {
    key: "render",
    value: function render() {
      this.container.append(this.dom);
    }
  }], [{
    key: "getComponentByDOM",
    value:
    /**
     * @param {HTMLElement} dom
     * @returns {?ImageComponent}
     */
    function getComponentByDOM(dom) {
      var hashID = parseInt(dom.getAttribute("hash-lookup-id"));
      if (dom.tagName.toLowerCase() === "im-image") {
        if (hashID in ImageComponent.imageComponentDOMLookupHash) {
          return ImageComponent.imageComponentDOMLookupHash[hashID];
        }
      }
      return null;
    }
  }]);
}();
/** @type {number} */
_defineProperty(ImageComponent, "currentImageComponentHashNumber", 0);
/** @type {{int: ImageComponent}} */
_defineProperty(ImageComponent, "imageComponentDOMLookupHash", {});
export default ImageComponent;