function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); }
import ContentChangedHandler from "../../ContentChangedHandler.js";
import PageEditorStates from "../PageEditorStates.js";
import BreadcrumbsManager from "../BreadcrumbsManager.js";
var _internalIndex = /*#__PURE__*/new WeakMap();
var Breadcrumb = /*#__PURE__*/function () {
  /**
   *
   * @param {string} label
   * @param {string} uri
   */
  function Breadcrumb(label, uri) {
    _classCallCheck(this, Breadcrumb);
    _defineProperty(this, "label", void 0);
    _defineProperty(this, "labelDOMInput", void 0);
    _defineProperty(this, "uri", void 0);
    _defineProperty(this, "uriDOMInput", void 0);
    _defineProperty(this, "dom", void 0);
    _classPrivateFieldInitSpec(this, _internalIndex, void 0);
    _classPrivateFieldSet(_internalIndex, this, Breadcrumb.nextIndex++);
    this.label = label;
    this.uri = uri;
    this.dom = this.getDOM();
  }
  return _createClass(Breadcrumb, [{
    key: "delete",
    value: function _delete() {
      this.dom.remove();

      // Remove it from the breadcrumbs static array
      var indexToRemove = null;
      for (var index in BreadcrumbsManager.breadcrumbs) {
        var crumb = BreadcrumbsManager.breadcrumbs[index];
        if (_classPrivateFieldGet(_internalIndex, crumb) === _classPrivateFieldGet(_internalIndex, this)) {
          indexToRemove = index;
        }
      }
      BreadcrumbsManager.breadcrumbs.splice(indexToRemove, 1);
    }

    /**
     * Prefills the breadcrumb with the current page name and URI
     */
  }, {
    key: "prefill",
    value: function prefill() {
      var currentPageName = document.querySelector("#page-name").value.trim();
      var currentPageRoute = document.querySelector("#page-url").value.trim();
      this.labelDOMInput.value = currentPageName;
      this.uriDOMInput.value = currentPageRoute;
      this.uri = currentPageRoute;
      this.label = currentPageName;
    }

    /**
     * @returns {HTMLDivElement}
     */
  }, {
    key: "getDOM",
    value: function getDOM() {
      var _this = this;
      var template = document.createElement("div");
      template.classList.add("crumb");
      template.classList.add("mb-2");
      template.innerHTML = "\n\t\t\t<div class=\"me-2\">\n\t\t\t\t<label>Crumb label</label>\n\t\t\t\t<div class=\"input-group\">\n\t\t\t\t\t<span class=\"input-group-text\"><i class=\"bi bi-input-cursor-text\"></i></span>\n\t\t\t\t\t<input type=\"text\" class=\"crumb-label form-control\" placeholder=\"Label\" value=\"".concat(this.label, "\">\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<div>\n\t\t\t\t<label>Crumb URI</label>\n\t\t\t\t<div class=\"input-group\">\n\t\t\t\t\t<span class=\"input-group-text\"><i class=\"bi bi-input-cursor-text\"></i></span>\n\t\t\t\t\t<input type=\"text\" class=\"crumb-uri form-control\" placeholder=\"URI\" value=\"").concat(this.uri, "\">\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<button type=\"button\" class=\"square delete-button btn btn-danger btn-sm\">\n\t\t\t\t<svg width=\"1rem\" height=\"1rem\" viewBox=\"0 0 16 16\" class=\"bi bi-trash-fill\" fill=\"currentColor\" xmlns=\"http://www.w3.org/2000/svg\">\n\t\t\t\t\t<path fill-rule=\"evenodd\" d=\"M2.5 1a1 1 0 0 0-1 1v1a1 1 0 0 0 1 1H3v9a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2V4h.5a1 1 0 0 0 1-1V2a1 1 0 0 0-1-1H10a1 1 0 0 0-1-1H7a1 1 0 0 0-1 1H2.5zm3 4a.5.5 0 0 1 .5.5v7a.5.5 0 0 1-1 0v-7a.5.5 0 0 1 .5-.5zM8 5a.5.5 0 0 1 .5.5v7a.5.5 0 0 1-1 0v-7A.5.5 0 0 1 8 5zm3 .5a.5.5 0 0 0-1 0v7a.5.5 0 0 0 1 0v-7z\"/>\n\t\t\t\t</svg>\n\t\t\t</button>\n\t\t\t<button type=\"button\" class=\"square prefill-crumb-button btn btn-primary btn-sm\">\n\t\t\t\t<span>Prefill</span>\n\t\t\t</button>\n\t\t");
      var labelInput = template.querySelector(".crumb-label");
      var uriInput = template.querySelector(".crumb-uri");
      var deleteButton = template.querySelector(".delete-button");
      var prefillButton = template.querySelector(".prefill-crumb-button");
      this.uriDOMInput = uriInput;
      this.labelDOMInput = labelInput;

      // Unsaved changes event
      labelInput.addEventListener("input", function () {
        _this.label = labelInput.value;
        ContentChangedHandler.onPageEditorDataChanged(PageEditorStates);
      });

      // Unsaved changes event
      uriInput.addEventListener("input", function () {
        _this.uri = uriInput.value;
        ContentChangedHandler.onPageEditorDataChanged(PageEditorStates);
      });

      // Delete crumb event
      deleteButton.addEventListener("click", function () {
        _this.delete();
        ContentChangedHandler.onPageEditorDataChanged(PageEditorStates);
      });

      // Prefill button event
      prefillButton.addEventListener("click", function () {
        _this.prefill();
        ContentChangedHandler.onPageEditorDataChanged(PageEditorStates);
      });

      // Add the new crumb to the crumbs container
      Breadcrumb.crumbsContainer.append(template);
      return template;
    }
  }]);
}();
_defineProperty(Breadcrumb, "crumbsContainer", document.querySelector("#crumbs-container"));
_defineProperty(Breadcrumb, "nextIndex", 1);
export default Breadcrumb;