function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * Keeps track of the selected project tag IDs
 */
import ProjectTagRow from "./components/ProjectTagRow.js";
import ProjectTagPageDataLabel from "./components/ProjectTagPageDataLabel.js";
import PageEditorStates from "./PageEditorStates.js";
import ContentChangedHandler from "../ContentChangedHandler.js";
var ProjectTagManager = /*#__PURE__*/function () {
  function ProjectTagManager() {
    _classCallCheck(this, ProjectTagManager);
    /** @type {number[]} */
    _defineProperty(this, "selectedProjectTagIDs", []);
    _defineProperty(this, "noTagsMessageContainer", document.querySelector("#no-project-tags-message"));
    _defineProperty(this, "labelsContainer", document.querySelector("#project-tags-labels"));
  }
  return _createClass(ProjectTagManager, [{
    key: "refreshEditorDisplayOfTags",
    value: function refreshEditorDisplayOfTags() {
      if (this.selectedProjectTagIDs.length === 0) {
        this.noTagsMessageContainer.style.display = null;
        this.labelsContainer.innerHTML = "";
        ProjectTagPageDataLabel.clearAll();
      } else {
        this.noTagsMessageContainer.style.display = "none";
      }
    }

    /**
     * Stores a project tag ID as having been selected
     * @param tagID
     */
  }, {
    key: "addTagIDToSelected",
    value: function addTagIDToSelected(tagID) {
      if (this.selectedProjectTagIDs.indexOf(tagID) === -1) {
        ContentChangedHandler.onPageEditorDataChanged(PageEditorStates);
        var tagName = ProjectTagRow.getProjectTagByTagID(tagID).tagLabel;
        new ProjectTagPageDataLabel(tagID, tagName);
        this.selectedProjectTagIDs.push(tagID);
        this.refreshEditorDisplayOfTags();
      }
    }

    /**
     * Deselects a project tag ID
     * @param tagID
     */
  }, {
    key: "removeTagIDFromSelected",
    value: function removeTagIDFromSelected(tagID) {
      var index = this.selectedProjectTagIDs.indexOf(tagID);
      if (index !== -1) {
        ContentChangedHandler.onPageEditorDataChanged(PageEditorStates);
        this.selectedProjectTagIDs.splice(index, 1);
        this.refreshEditorDisplayOfTags();
        ProjectTagPageDataLabel.removeRowByID(tagID);
      }
    }

    /**
     * Clears the current project tag ID selection
     */
  }, {
    key: "clearSelectedTagIDs",
    value: function clearSelectedTagIDs() {
      this.selectedProjectTagIDs = [];
      this.refreshEditorDisplayOfTags();
    }
  }]);
}();
export default new ProjectTagManager();