function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
* Singleton that stores states about the page editor
* that other files/classes can read from
* to get information about the current states of the
* page editor.
*/
var PageEditorStates = /*#__PURE__*/function () {
  function PageEditorStates() {
    _classCallCheck(this, PageEditorStates);
    /**
     * The current page loaded into the editor
     * @type {{id:int, pageName: string, pageType: string, pageRoute: string, pageBody: string, pageHead: string, pageRouteIsRegex: int, pageLayout: string, creationTime: int, excludeFromSitemap: int, excludeSchemaInjection: int, publicationStatus: int, publicationTimestamp: int, isDeleted: int, attributes: Object[]} | null}
     */
    _defineProperty(this, "currentPage", null);
    /**
     * The current page layout section definition loaded into the editor from the current page's selected layout,
     * if there is one.
     * @type {{id: number, creationTimestamp: number, layoutFileName: string, pageLayoutSections: Object[]} | null}
     */
    _defineProperty(this, "currentPageLayoutSectionDefinition", null);
    /**
     * These are the last loaded page content sections. Note that this property is _not_ updated unless a page is
     * loaded or a page is saved. Editing the content sections does not reflect here until saving.
     * @type {{id: number, content: string, pageId: number, sectionName: string}[]}
     */
    _defineProperty(this, "lastLoadedPageContentSections", null);
    /** @type {string} Type of view mode. Either STANDARD or REVISION */
    this.viewType = "";
    if (document.querySelector("#page-editor-viewing-type") !== null) {
      this.viewType = document.querySelector("#page-editor-viewing-type").value;
    }

    /** @type {boolean} Whether or not a page is currently being loaded into the editor */
    this.isLoadingPage = false;

    /** @type {boolean} Whether or not the current page is being saved */
    this.isSavingPage = false;

    /** @property {number|null} */
    this.currentPageID = null;

    /** @property {string|null} currentPageType */
    this.currentPageType = null;

    /** @property {bool} */
    this.unsavedChanges = false;

    /** @property {AceEditorExtension} currentEditor The current instance of the active editor */
    this.currentEditor = null;

    /** @property {?string} */
    this.currentEditorWindowName = "body";

    /** @property {object} */
    this.currentLinkContextMenu = null;
  }

  /**
   * @param {boolean} forceState Will ignore any if conditions that would otherwise prevent this from marking unsaved changes.
   */
  return _createClass(PageEditorStates, [{
    key: "markAsHavingUnsavedChanges",
    value: function markAsHavingUnsavedChanges(forceState) {
      // Do not allow this method to mark changes as unsaved if loading in new data
      if (this.isLoadingPage && !forceState) {
        return;
      }

      // If this is a revision, no changes are possible anyway
      if (this.viewType === "REVISION") {
        return;
      }
      this.unsavedChanges = true;
    }
  }, {
    key: "markChangesSaved",
    value: function markChangesSaved() {
      this.unsavedChanges = false;
    }
  }]);
}();
export default new PageEditorStates();