function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
import BreadcrumbsManager from "./BreadcrumbsManager.js";
import ArticleCategoryManager from "./ArticleCategoryManager.js";
import ArticleCategoryRow from "./components/ArticleCategoryRow.js";
import ProjectTagManager from "./ProjectTagManager.js";
import ProjectTagRow from "./components/ProjectTagRow.js";
import AceEditorExtension from "../AceEditorExtension.js";
import Breadcrumb from "./components/Breadcrumb.js";
import PageEditor from "./PageEditor.js";
import PageEditorStates from "./PageEditorStates.js";
import ContentChangedHandler from "../ContentChangedHandler.js";
import DOMHelper from "../DOMHelper.js";
import PageCity from "./shortcode-buttons/PageCity.js";
import PageState from "./shortcode-buttons/PageState.js";
import PageAttribute from "./components/PageAttribute.js";
import { PageContentSectionEditor } from "./components/PageContentSectionEditor.js";

/**
 * Helper class that will take page data and load it into value fields
 */
var PageContentLoader = /*#__PURE__*/function () {
  function PageContentLoader() {
    _classCallCheck(this, PageContentLoader);
    _defineProperty(this, "viewPageButton", document.querySelector("#view-page-external-link-button"));
    _defineProperty(this, "pageNameInput", document.querySelector("#page-name"));
    _defineProperty(this, "pageLayoutInput", document.querySelector("#page-layout"));
    _defineProperty(this, "pageURLInput", document.querySelector("#page-url"));
    _defineProperty(this, "pageIdDisplay", document.querySelector("#page-id"));
    _defineProperty(this, "excludeFromSitemapCheckbox", document.querySelector("#exclude-from-sitemap"));
    _defineProperty(this, "excludeFromSchemaInjection", document.querySelector("#exclude-json-schema"));
    _defineProperty(this, "pagePublicationInput", document.querySelector("#page-publication"));
    _defineProperty(this, "pagePublicationDateTimeInput", document.querySelector("#page-publication-timestamp"));
    _defineProperty(this, "pagePublicationDateTimeContainer", document.querySelector("#page-publication-datetime-container"));
    _defineProperty(this, "featuredImageContainer", document.querySelector("#page-data-featured-image"));
    _defineProperty(this, "featuredImage", document.querySelector("#featured-image"));
    _defineProperty(this, "featuredImageInput", document.querySelector("#featured-image-input"));
    _defineProperty(this, "featuredImageThumbInput", document.querySelector("#featured-image-thumb-input"));
    _defineProperty(this, "projectDataContainer", document.querySelector("#page-data-project"));
    _defineProperty(this, "projectFeaturedImageContainer", document.querySelector("#page-data-project-featured-image-container"));
    _defineProperty(this, "blogDataContainer", document.querySelector("#page-data-blog"));
    _defineProperty(this, "blogFeaturedImageContainer", document.querySelector("#page-data-blog-featured-image-container"));
    _defineProperty(this, "serviceDataContainer", document.querySelector("#page-data-service"));
    _defineProperty(this, "serviceFeaturedImageContainer", document.querySelector("#page-data-service-featured-image-container"));
    _defineProperty(this, "cityDataContainer", document.querySelector("#page-data-city"));
    _defineProperty(this, "cityFeaturedImageContainer", document.querySelector("#page-data-city-featured-image-container"));
    // Project type specific fields
    _defineProperty(this, "projectCityNameInput", document.querySelector("#city-name"));
    _defineProperty(this, "projectStateNameInput", document.querySelector("#state-name"));
    _defineProperty(this, "projectStateNameShorthandInput", document.querySelector("#state-name-shorthand"));
    _defineProperty(this, "brandsProductsInput", document.querySelector("#brands-products"));
    _defineProperty(this, "customerTestimonialCheckbox", document.querySelector("#customer-testimonial-check"));
    _defineProperty(this, "projectCustomerReviewSectionContainer", document.querySelector("#ipp-customer-review-container"));
    _defineProperty(this, "customerReviewFirstName", document.querySelector("#customer-review-first-name"));
    _defineProperty(this, "customerReviewLastName", document.querySelector("#customer-review-last-name"));
    _defineProperty(this, "customerReviewTestimonial", document.querySelector("#customer-testimonial-body"));
    // City type specific fields
    _defineProperty(this, "cityCityNameInput", document.querySelector("#city-page-city-name"));
    _defineProperty(this, "cityStateNameInput", document.querySelector("#city-page-state-name"));
    _defineProperty(this, "cityStateNameShorthandInput", document.querySelector("#city-page-state-name-shorthand"));
    _defineProperty(this, "cityCityURLInput", document.querySelector("#city-page-city-url"));
    // Page attributes
    _defineProperty(this, "attributesDataContainer", document.querySelector("#page-data-attributes"));
  }
  return _createClass(PageContentLoader, [{
    key: "loadPage",
    value:
    /**
     * Loads a page's content into the body editor, head editor, and the page data fields. If a page is sent
     * with layout sections, then the body editor is not used and we render section components instead.
     * @param {Object} page
     * @param {Object[]|null} pageContentSections
     * @param {Object|null} pageLayoutSectionDefinition
     */
    function loadPage(page, pageContentSections, pageLayoutSectionDefinition) {
      // Load the pageBody only if there are no content sections
      if (pageLayoutSectionDefinition !== null) {
        this.loadPageContentSections(pageContentSections, pageLayoutSectionDefinition);
      }

      // In both cases, still load the pageBody so any existing pageBody continues to be retained
      AceEditorExtension.pageEditors.body.ace.session.setValue(page.pageBody);
      AceEditorExtension.pageEditors.head.ace.session.setValue(page.pageHead);
      this.viewPageButton.setAttribute("href", page.pageRoute);
      this.pageNameInput.value = page.pageName;
      this.pageURLInput.value = page.pageRoute;
      this.pageIdDisplay.innerHTML = page.id;
      this.excludeFromSitemapCheckbox.checked = page.excludeFromSitemap === 1;
      this.excludeFromSchemaInjection.checked = page.excludeSchemaInjection === 1;

      // Try and infer the page layout from the page type if the page layout is blank
      if (page.pageLayout === "") {
        // Set it to blank anyway to override a previous value from a previous page load
        this.pageLayoutInput.value = "";
        var layoutOptions = this.pageLayoutInput.querySelectorAll("option");
        var _iterator = _createForOfIteratorHelper(layoutOptions),
          _step;
        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var layoutOption = _step.value;
            if (layoutOption.value === page.pageType) {
              this.pageLayoutInput.value = layoutOption.value;
              PageEditorStates.markAsHavingUnsavedChanges(true);
              ContentChangedHandler.showUnsavedChangeIdentifier(DOMHelper.getAllPageEditorTabs().data);
              break;
            }
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }
      } else {
        this.pageLayoutInput.value = page.pageLayout;
      }

      // For the Convert Page feature, hide the page type this page already is
      var _iterator2 = _createForOfIteratorHelper(document.querySelectorAll("#convert-page-new-page-type option")),
        _step2;
      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var option = _step2.value;
          if (option.value === page.pageType) {
            option.style.display = "none";
          } else {
            option.style.display = null;
          }
        }

        // Load the publication status and time - if not a draft
        // 0 = Draft, 1 = Published
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }
      if (page.publicationStatus === 0) {
        // Draft
        this.pagePublicationInput.value = page.publicationStatus;
        this.pagePublicationDateTimeInput.value = '';
        this.pagePublicationDateTimeContainer.style.display = "none";
      } else if (page.publicationStatus === 1) {
        // Published
        this.pagePublicationInput.value = page.publicationStatus;
        if (page.publicationTimestamp > 0) {
          // Multiply by 1000 because it is saved in seconds, but Date takes milliseconds
          var publicationDate = new Date(page.publicationTimestamp * 1000);

          // Set it to local time, as publicationTimestamp is in UNIX time
          publicationDate.setMinutes(publicationDate.getMinutes() - publicationDate.getTimezoneOffset());
          this.pagePublicationDateTimeInput.value = publicationDate.toISOString().slice(0, 16);
        } else {
          this.pagePublicationDateTimeInput.value = '';
        }
        this.pagePublicationDateTimeContainer.style.display = null;
      }
    }

    /**
     * Builds and renders page content section editors for each pageLayoutSection in pageLayoutSectionDefinition.
     * @param {{id: number, pageId: number, sectionName: string, content: string | null}[]|null} pageContentSections
     * @param {{id: number, creationTimestamp: number, layoutFileName: string, pageLayoutSections: Object[]}|null} pageLayoutSectionDefinition
     */
  }, {
    key: "loadPageContentSections",
    value: function loadPageContentSections(pageContentSections, pageLayoutSectionDefinition) {
      /** @type {{id: number, creationTimestamp: number, pageLayoutSectionDefinitionId: number, sectionName: string}[]} */
      var pageLayoutSections = pageLayoutSectionDefinition.pageLayoutSections;
      var _iterator3 = _createForOfIteratorHelper(pageLayoutSections),
        _step3;
      try {
        var _loop = function _loop() {
          var _pageContentSectionMa;
          var layoutSection = _step3.value;
          // Get the pageContentSection on this page that matches the pageLayoutSection name, if any
          var pageContentSectionMatchingSectionName = pageContentSections.filter(function (pageContentSection) {
            return pageContentSection.sectionName.toLowerCase() === layoutSection.sectionName.toLowerCase();
          });
          var component = new PageContentSectionEditor(layoutSection, (_pageContentSectionMa = pageContentSectionMatchingSectionName[0]) !== null && _pageContentSectionMa !== void 0 ? _pageContentSectionMa : null);
          component.build().renderInto(document.querySelector("#page-sections-content-container"));
        };
        for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
          _loop();
        }
      } catch (err) {
        _iterator3.e(err);
      } finally {
        _iterator3.f();
      }
    }
  }, {
    key: "loadPageBreadcrumbs",
    value: function loadPageBreadcrumbs(breadcrumbs) {
      // Clear existing breadcrumbs
      BreadcrumbsManager.clearBreadcrumbs();

      // Load breadcrumbs
      // Should be ordered correctly from the backend server already
      var _iterator4 = _createForOfIteratorHelper(breadcrumbs),
        _step4;
      try {
        for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
          var breadcrumbData = _step4.value;
          var newBreadcrumb = new Breadcrumb(breadcrumbData.label, breadcrumbData.uri);
          BreadcrumbsManager.breadcrumbs.push(newBreadcrumb);
          Breadcrumb.crumbsContainer.append(newBreadcrumb.dom);
        }
      } catch (err) {
        _iterator4.e(err);
      } finally {
        _iterator4.f();
      }
    }
  }, {
    key: "loadPageData",
    value: function loadPageData(page, pageData) {
      // Clear current article selections - if any
      ArticleCategoryManager.clearSelectedCategories();
      ArticleCategoryRow.showAllAsDeselected();

      // Clear current project tag selections - if any
      ProjectTagManager.clearSelectedTagIDs();
      ProjectTagRow.showAllAsDeselected();

      // Show the appropriate data sections
      PageEditor.hideDataSections();
      if (page.pageType === "General") {
        // Hide the Page City and Page State shortcode buttons
        if (PageCity.button) {
          PageCity.button.style.display = "none";
          PageState.button.style.display = "none";
        }
      } else if (page.pageType === "Service") {
        // Hide the Page City and Page State shortcode buttons
        if (PageCity.button) {
          PageCity.button.style.display = "none";
          PageState.button.style.display = "none";
        }

        // Show the featured image and move it to the service featured image container

        // Featured image and service section
        this.featuredImageContainer.style.display = "block";
        this.serviceDataContainer.style.display = "block";
        this.serviceFeaturedImageContainer.append(this.featuredImageContainer);

        // Load the featured image, if set
        if ("FEATURED_IMAGE" in pageData && "FEATURED_IMAGE_THUMB" in pageData) {
          this.featuredImage.setAttribute("src", pageData.FEATURED_IMAGE_THUMB);
          this.featuredImageInput.value = pageData.FEATURED_IMAGE;
          this.featuredImageThumbInput.value = pageData.FEATURED_IMAGE_THUMB;
        } else {
          // Clear them
          this.featuredImageContainer.setAttribute("src", null);
          this.featuredImageInput.value = "";
          this.featuredImageThumbInput.value = "";
        }
      } else if (page.pageType === "Blog") {
        // Hide the Page City and Page State shortcode buttons
        if (PageCity.button) {
          PageCity.button.style.display = "none";
          PageState.button.style.display = "none";
        }

        // Show the featured image and move it to the blog featured image container

        // Featured image and blog section, in that order sir
        this.featuredImageContainer.style.display = "block";
        this.blogDataContainer.style.display = "block";
        this.blogFeaturedImageContainer.append(this.featuredImageContainer);

        // Load the featured image, if set
        if ("FEATURED_IMAGE" in pageData && "FEATURED_IMAGE_THUMB" in pageData) {
          this.featuredImage.setAttribute("src", pageData.FEATURED_IMAGE_THUMB);
          this.featuredImageInput.value = pageData.FEATURED_IMAGE;
          this.featuredImageThumbInput.value = pageData.FEATURED_IMAGE_THUMB;
        } else {
          // Clear them
          this.featuredImageContainer.setAttribute("src", null);
          this.featuredImageInput.value = "";
          this.featuredImageThumbInput.value = "";
        }

        // Load article categories
        if ("ARTICLE_CATEGORY" in pageData) {
          var articleCategoriesToLoad = [];
          if (Array.isArray(pageData.ARTICLE_CATEGORY)) {
            articleCategoriesToLoad = pageData.ARTICLE_CATEGORY;
          } else {
            articleCategoriesToLoad.push(pageData.ARTICLE_CATEGORY);
          }
          var _iterator5 = _createForOfIteratorHelper(articleCategoriesToLoad),
            _step5;
          try {
            for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
              var categoryID = _step5.value;
              ArticleCategoryManager.addCategoryToSelected(parseInt(categoryID));
              var row = ArticleCategoryRow.getByArticleCategoryID(parseInt(categoryID));
              if (row !== null) {
                // Show as selected
                row.showAsSelected();
              }
            }
          } catch (err) {
            _iterator5.e(err);
          } finally {
            _iterator5.f();
          }
        }
      } else if (page.pageType === "Project") {
        // Show the Page City and Page State shortcode buttons
        if (PageCity.button) {
          PageCity.button.style.display = null;
          PageState.button.style.display = null;
        }

        // Show the featured image and move it to the project featured image container

        // Featured image and project section
        this.featuredImageContainer.style.display = "block";
        this.projectDataContainer.style.display = "block";
        this.projectFeaturedImageContainer.append(this.featuredImageContainer);
        if ("CITY_NAME" in pageData) {
          this.projectCityNameInput.value = pageData.CITY_NAME;
        } else {
          this.projectCityNameInput.value = "";
        }
        if ("STATE_NAME" in pageData) {
          this.projectStateNameInput.value = pageData.STATE_NAME;
        } else {
          this.projectStateNameInput.value = "";
        }
        if ("STATE_NAME_SHORTHAND" in pageData) {
          this.projectStateNameShorthandInput.value = pageData.STATE_NAME_SHORTHAND;
        } else {
          this.projectStateNameShorthandInput.value = "";
        }
        if ("PROJECT_BRANDS_PRODUCTS" in pageData) {
          this.brandsProductsInput.value = pageData.PROJECT_BRANDS_PRODUCTS;
        } else {
          this.brandsProductsInput.value = "";
        }

        // Load the featured image, if set
        if ("FEATURED_IMAGE" in pageData && "FEATURED_IMAGE_THUMB" in pageData) {
          this.featuredImage.setAttribute("src", pageData.FEATURED_IMAGE_THUMB);
          this.featuredImageInput.value = pageData.FEATURED_IMAGE;
          this.featuredImageThumbInput.value = pageData.FEATURED_IMAGE_THUMB;
        } else {
          // Clear them
          this.featuredImage.setAttribute("src", null);
          this.featuredImageInput.value = "";
          this.featuredImageThumbInput.value = "";
        }
        if ("CUSTOMER_DID_LEAVE_REVIEW" in pageData) {
          this.customerTestimonialCheckbox.checked = pageData.CUSTOMER_DID_LEAVE_REVIEW === "1";
          if (pageData.CUSTOMER_DID_LEAVE_REVIEW === "1") {
            this.projectCustomerReviewSectionContainer.style.display = null;
          } else {
            // Disable the IPP customer review container
            // Also clear the customer review fields in case a previously loaded page
            // had those fields populated
            this.projectCustomerReviewSectionContainer.style.display = "none";
            this.customerReviewFirstName.value = "";
            this.customerReviewLastName.value = "";
            this.customerReviewTestimonial.value = "";
          }
        } else {
          this.customerTestimonialCheckbox.checked = false;
          this.projectCustomerReviewSectionContainer.style.display = "none";
          // Because this page has loaded with no "customer review" - clear the fields if a previous
          // page was loaded and had those values populated
          this.customerReviewFirstName.value = "";
          this.customerReviewLastName.value = "";
          this.customerReviewTestimonial.value = "";
        }
        if ("CUSTOMER_REVIEW_FIRST_NAME" in pageData) {
          this.customerReviewFirstName.value = pageData.CUSTOMER_REVIEW_FIRST_NAME;
        } else {
          this.customerReviewFirstName.value = "";
        }
        if ("CUSTOMER_REVIEW_LAST_NAME" in pageData) {
          this.customerReviewLastName.value = pageData.CUSTOMER_REVIEW_LAST_NAME;
        } else {
          this.customerReviewLastName.value = "";
        }
        if ("CUSTOMER_REVIEW_TESTIMONIAL" in pageData) {
          this.customerReviewTestimonial.value = pageData.CUSTOMER_REVIEW_TESTIMONIAL;
        } else {
          this.customerReviewTestimonial.value = "";
        }
        if ("PROJECT_TAG" in pageData) {
          var projectTagIDsToLoad = [];
          if (Array.isArray(pageData.PROJECT_TAG)) {
            projectTagIDsToLoad = pageData.PROJECT_TAG;
          } else {
            projectTagIDsToLoad.push(pageData.PROJECT_TAG);
          }
          var _iterator6 = _createForOfIteratorHelper(projectTagIDsToLoad),
            _step6;
          try {
            for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
              var tagID = _step6.value;
              ProjectTagManager.addTagIDToSelected(parseInt(tagID));
              var _row = ProjectTagRow.getProjectTagByTagID(parseInt(tagID));
              if (_row !== null) {
                // Show as selected
                _row.showAsSelected();
              }
            }
          } catch (err) {
            _iterator6.e(err);
          } finally {
            _iterator6.f();
          }
        }
      } else if (page.pageType === "City") {
        // Show the Page City and Page State shortcode buttons
        if (PageCity.button) {
          PageCity.button.style.display = null;
          PageState.button.style.display = null;
        }

        // Show the featured image and move it to the blog featured image container

        // Featured image and blog section, in that order sir
        this.featuredImageContainer.style.display = "block";
        this.cityDataContainer.style.display = "block";
        this.cityFeaturedImageContainer.append(this.featuredImageContainer);

        // Load the featured image, if set
        if ("FEATURED_IMAGE" in pageData && "FEATURED_IMAGE_THUMB" in pageData) {
          this.featuredImage.setAttribute("src", pageData.FEATURED_IMAGE_THUMB);
          this.featuredImageInput.value = pageData.FEATURED_IMAGE;
          this.featuredImageThumbInput.value = pageData.FEATURED_IMAGE_THUMB;
        } else {
          // Clear them
          this.featuredImageContainer.setAttribute("src", null);
          this.featuredImageInput.value = "";
          this.featuredImageThumbInput.value = "";
        }

        // City section
        this.cityDataContainer.style.display = "block";

        // Load city page data
        if ("CITY_NAME" in pageData) {
          this.cityCityNameInput.value = pageData.CITY_NAME;
        } else {
          this.cityCityNameInput.value = "";
        }
        if ("STATE_NAME" in pageData) {
          this.cityStateNameInput.value = pageData.STATE_NAME;
        } else {
          this.cityStateNameInput.value = "";
        }
        if ("STATE_NAME_SHORTHAND" in pageData) {
          this.cityStateNameShorthandInput.value = pageData.STATE_NAME_SHORTHAND;
        } else {
          this.cityStateNameShorthandInput.value = "";
        }
        if ("OFFICIAL_CITY_URL" in pageData) {
          this.cityCityURLInput.value = pageData.OFFICIAL_CITY_URL;
        } else {
          this.cityCityURLInput.value = "";
        }
      }
    }
  }, {
    key: "loadPageAttributes",
    value: function loadPageAttributes(attributes) {
      PageAttribute.clearAll();
      var noResultsMessage = document.querySelector("#no-attributes-message-container");

      // In all cases, show the page attributes data section
      this.attributesDataContainer.style.display = null;
      if (attributes.length > 0) {
        noResultsMessage.style.display = "none";
        var _iterator7 = _createForOfIteratorHelper(attributes),
          _step7;
        try {
          for (_iterator7.s(); !(_step7 = _iterator7.n()).done;) {
            var attribute = _step7.value;
            var pageAttribute = new PageAttribute(attribute.id, attribute.name, attribute.value, attribute.pageAttributeID);
            pageAttribute.render();
          }
        } catch (err) {
          _iterator7.e(err);
        } finally {
          _iterator7.f();
        }
      } else {
        noResultsMessage.style.display = null;
      }
    }
  }]);
}();
export default new PageContentLoader();