function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
import PageEditorStates from "./PageEditorStates.js";

/**
* An abstract wrapper for other classes and code
* to call methods in order to manipulate
* whatever editor is active for the user.
*/
var EditorWrapper = /*#__PURE__*/function () {
  function EditorWrapper() {
    _classCallCheck(this, EditorWrapper);
  }
  return _createClass(EditorWrapper, [{
    key: "isActiveEditorAceEditor",
    value:
    /**
    * Tells if the currently active editor
    * is an instance of the ace editor
    */
    function isActiveEditorAceEditor() {
      return this.isVarAceEditor(PageEditorStates.currentEditor.ace);
    }

    /**
    * Checks if a variable is _probably_
    * an instances of the ace editor
    * @param {object} obj
    */
  }, {
    key: "isVarAceEditor",
    value: function isVarAceEditor(obj) {
      // Check for an ace-specific property
      return obj.hasOwnProperty("$behavioursEnabled");
    }

    /**
    * Inserts text to wherever the cursor currently is
    * in the current editor.
    * @param {string} text
    */
  }, {
    key: "insertTextAtCursor",
    value: function insertTextAtCursor(text) {
      var editor = PageEditorStates.currentEditor.ace;
      if (editor !== null) {
        if (this.isActiveEditorAceEditor()) {
          // Ace editor
          editor.session.replace(editor.session.getSelection().getRange(), text);
        }
      }
    }

    /**
    * Changes the focus to be in the current active editor
    */
  }, {
    key: "focusEditor",
    value: function focusEditor() {
      var editor = PageEditorStates.currentEditor.ace;
      if (editor !== null) {
        if (this.isActiveEditorAceEditor()) {
          // Ace editor
          editor.focus();
        }
      }
    }
  }]);
}();
export default new EditorWrapper();