function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
import PageEditorStates from "./PageEditorStates.js";
import DOMHelper from "../DOMHelper.js";
import AceEditorExtension from "../AceEditorExtension.js";

/**
* Logic and events for the editor tabs
* above the page editor
*/
var EditorTabs = /*#__PURE__*/function () {
  function EditorTabs() {
    var _this = this;
    _classCallCheck(this, EditorTabs);
    if (PageEditorStates.viewingState !== "") {
      // Prepare the editor tab events
      var editorTabs = DOMHelper.getAllPageEditorTabs();

      // Connect events to the editor tabs when they are clicked
      var _loop = function _loop() {
        var windowName = _Object$keys[_i];
        var tab = editorTabs[windowName];
        tab.addEventListener("click", function (e) {
          _this.tabClicked(tab, e);
        });
      };
      for (var _i = 0, _Object$keys = Object.keys(editorTabs); _i < _Object$keys.length; _i++) {
        _loop();
      }
    }
  }

  /**
  * When an editor tab is clicked
  * @param {DOMNode} tab
  * @param {event} e
  */
  return _createClass(EditorTabs, [{
    key: "tabClicked",
    value: function tabClicked(tab, e) {
      var currentWindowName = PageEditorStates.currentEditorWindowName;
      var windowChosen = tab.getAttribute("data-window");
      var pageWindows = DOMHelper.getAllPageEditorWindows();
      var editorTabs = DOMHelper.getAllPageEditorTabs();
      if (currentWindowName !== windowChosen) {
        // Get the DOMs for the current and previous windows
        var currentWindow;
        var newWindow;
        if (currentWindowName === "body" && PageEditorStates.currentPageLayoutSectionDefinition !== null) {
          currentWindow = pageWindows["bodySections"];
        } else {
          currentWindow = pageWindows[currentWindowName];
        }
        if (windowChosen === "body") {
          // Determine if we should show the main body editor, or the body sections editors
          if (PageEditorStates.currentPageLayoutSectionDefinition !== null) {
            newWindow = pageWindows["bodySections"];
            PageEditorStates.currentEditorWindowName = "body";
          } else {
            newWindow = pageWindows[windowChosen];
            PageEditorStates.currentEditorWindowName = windowChosen;
          }
        } else {
          newWindow = pageWindows[windowChosen];
          PageEditorStates.currentEditorWindowName = windowChosen;
        }

        // Visually change which editor tab is selected
        editorTabs[currentWindowName].classList.remove("selected");
        editorTabs[windowChosen].classList.add("selected");

        // Show the new window and hide the current one
        currentWindow.style.display = "none";
        newWindow.style.display = null;

        // Set the current active editor
        if (windowChosen === "body" && PageEditorStates.currentPageLayoutSectionDefinition === null) {
          // Current active is the body editor
          PageEditorStates.currentEditor = AceEditorExtension.pageEditors.body;
          AceEditorExtension.pageEditors.body.ace.resize();
        } else if (windowChosen === "head") {
          PageEditorStates.currentEditor = AceEditorExtension.pageEditors.head;
          AceEditorExtension.pageEditors.head.ace.resize();
        } else {
          PageEditorStates.currentEditor = null;
        }
      }
    }
  }]);
}();
export default new EditorTabs();