function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
import AceEditorExtension from "../AceEditorExtension.js";
import ContentChangedHandler from "../ContentChangedHandler.js";
import FileEditorStates from "./FileEditorStates.js";
import DOMHelper from "../DOMHelper.js";
import EditorFileTab from "./EditorFileTab.js";
import SidebarFileLoader from "./SidebarFileLoader.js";
import DragImportHandler from "./DragImportHandler.js";
import ImageManager from "./../../image-manager/ImageManager.js";
import OpenImageManagerButton from "./components/OpenImageManagerButton.js";
import { ThemeSelector } from "./ThemeSelector.js";

// Modals
import NewDirectoryModal from "./modals/NewDirectoryModal.js";
import NewFileModal from "./modals/NewFileModal.js";
import { LayoutSectionsModal } from "./modals/LayoutSectionsModal.js";

// Forms
import NewDirectoryForm from "./forms/NewDirectoryForm.js";
import NewFileForm from "./forms/NewFileForm.js";
import RenameFileForm from "./forms/RenameFileForm.js";
import RenameDirectoryForm from "./forms/RenameDirectoryForm.js";
import FileEditorForm from "./forms/FileEditorForm.js";
import DirectoryFilterForm from "./forms/DirectoryFilterForm.js";

// PHP variable buttons
import CompanyPhoneNumbersPHPVariableButton from "./php-variable-buttons/CompanyPhone.js";
import PureCompanyPhone from "./php-variable-buttons/PureCompanyPhone.js";
import CompanyFaxNumbersPHPVariableButton from "./php-variable-buttons/CompanyFax.js";
import CompanyNamePHPVariableButton from "./php-variable-buttons/CompanyName.js";
import CompanyStreetPHPVariableButton from "./php-variable-buttons/CompanyStreet.js";
import CompanyPostalPHPVariableButton from "./php-variable-buttons/CompanyPostal.js";
import CompanyCityPHPVariableButton from "./php-variable-buttons/CompanyCity.js";
import CompanyStatePHPVariableButton from "./php-variable-buttons/CompanyState.js";
import CompanyLogoPHPVariableButton from "./php-variable-buttons/CompanyLogo.js";
import MapKeyPHPVariableButton from "./php-variable-buttons/MapKey.js";
var FileEditor = /*#__PURE__*/function () {
  function FileEditor() {
    var _this = this;
    _classCallCheck(this, FileEditor);
    /**
     * @type {?ImageManager}
     */
    _defineProperty(this, "imageManager", null);
    /**
     * @type {OpenImageManagerButton}
     */
    _defineProperty(this, "openImageManagerButton", void 0);
    /**
     * @type {LayoutSectionsModal}
     */
    _defineProperty(this, "layoutSectionsModal", void 0);
    /**
     * @type {HTMLButtonElement}
     */
    _defineProperty(this, "openLayoutSectionsModalButton", document.querySelector("#layout-sections-button"));
    this.layoutSectionsModal = new LayoutSectionsModal();
    this.loadImageManager();
    this.openImageManagerButton = new OpenImageManagerButton(this);

    // Get the ace editors for the file editor
    var aceEditors = DOMHelper.getThemeManagerAceEditors();

    // Load the extra, custom commands into the editors
    var fileExtension = new AceEditorExtension(aceEditors.file.container, null);
    fileExtension.loadHighlightInnerTag();
    fileExtension.loadLinkize();
    fileExtension.loadBold();
    fileExtension.loadParagraphize();
    fileExtension.loadLinkContextMenu();
    fileExtension.loadPasteFormatter();

    // Event for if there are unsaved changes. Block browser navigation
    window.addEventListener("beforeunload", function (e) {
      // Check if any tabs have unsaved changes
      for (var _i = 0, _Object$values = Object.values(EditorFileTab.registeredButtons); _i < _Object$values.length; _i++) {
        /** @type {EditorFileTab} */var tab = _Object$values[_i];
        if (tab.hasUnsavedChanges()) {
          e.preventDefault();
          e.returnValue = "You have unsaved changes. Are you sure you want to leave?";
          return false;
        }
      }
    });

    // Override Ctrl+S for the window
    window.addEventListener("keydown", function (e) {
      if (e.ctrlKey && e.key.toLowerCase() === "s") {
        e.preventDefault();
        e.stopPropagation();

        // Submit the file editor save form
        FileEditorForm.onSubmit();
      }
    });
    this.openLayoutSectionsModalButton.addEventListener("click", function () {
      _this.layoutSectionsModal.showModal();
    });
  }
  return _createClass(FileEditor, [{
    key: "loadImageManager",
    value: function loadImageManager() {
      var imageManagerPermInput = document.querySelector("#has-image-manager-perms");
      if (imageManagerPermInput.value === "1") {
        this.imageManager = new ImageManager(document.querySelector("#image-manager-container"));
      }
    }
  }]);
}();
export default new FileEditor();