function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return exports; }; var exports = {}, Op = Object.prototype, hasOwn = Op.hasOwnProperty, defineProperty = Object.defineProperty || function (obj, key, desc) { obj[key] = desc.value; }, $Symbol = "function" == typeof Symbol ? Symbol : {}, iteratorSymbol = $Symbol.iterator || "@@iterator", asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator", toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag"; function define(obj, key, value) { return Object.defineProperty(obj, key, { value: value, enumerable: !0, configurable: !0, writable: !0 }), obj[key]; } try { define({}, ""); } catch (err) { define = function define(obj, key, value) { return obj[key] = value; }; } function wrap(innerFn, outerFn, self, tryLocsList) { var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator, generator = Object.create(protoGenerator.prototype), context = new Context(tryLocsList || []); return defineProperty(generator, "_invoke", { value: makeInvokeMethod(innerFn, self, context) }), generator; } function tryCatch(fn, obj, arg) { try { return { type: "normal", arg: fn.call(obj, arg) }; } catch (err) { return { type: "throw", arg: err }; } } exports.wrap = wrap; var ContinueSentinel = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var IteratorPrototype = {}; define(IteratorPrototype, iteratorSymbol, function () { return this; }); var getProto = Object.getPrototypeOf, NativeIteratorPrototype = getProto && getProto(getProto(values([]))); NativeIteratorPrototype && NativeIteratorPrototype !== Op && hasOwn.call(NativeIteratorPrototype, iteratorSymbol) && (IteratorPrototype = NativeIteratorPrototype); var Gp = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(IteratorPrototype); function defineIteratorMethods(prototype) { ["next", "throw", "return"].forEach(function (method) { define(prototype, method, function (arg) { return this._invoke(method, arg); }); }); } function AsyncIterator(generator, PromiseImpl) { function invoke(method, arg, resolve, reject) { var record = tryCatch(generator[method], generator, arg); if ("throw" !== record.type) { var result = record.arg, value = result.value; return value && "object" == typeof value && hasOwn.call(value, "__await") ? PromiseImpl.resolve(value.__await).then(function (value) { invoke("next", value, resolve, reject); }, function (err) { invoke("throw", err, resolve, reject); }) : PromiseImpl.resolve(value).then(function (unwrapped) { result.value = unwrapped, resolve(result); }, function (error) { return invoke("throw", error, resolve, reject); }); } reject(record.arg); } var previousPromise; defineProperty(this, "_invoke", { value: function value(method, arg) { function callInvokeWithMethodAndArg() { return new PromiseImpl(function (resolve, reject) { invoke(method, arg, resolve, reject); }); } return previousPromise = previousPromise ? previousPromise.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(innerFn, self, context) { var state = "suspendedStart"; return function (method, arg) { if ("executing" === state) throw new Error("Generator is already running"); if ("completed" === state) { if ("throw" === method) throw arg; return doneResult(); } for (context.method = method, context.arg = arg;;) { var delegate = context.delegate; if (delegate) { var delegateResult = maybeInvokeDelegate(delegate, context); if (delegateResult) { if (delegateResult === ContinueSentinel) continue; return delegateResult; } } if ("next" === context.method) context.sent = context._sent = context.arg;else if ("throw" === context.method) { if ("suspendedStart" === state) throw state = "completed", context.arg; context.dispatchException(context.arg); } else "return" === context.method && context.abrupt("return", context.arg); state = "executing"; var record = tryCatch(innerFn, self, context); if ("normal" === record.type) { if (state = context.done ? "completed" : "suspendedYield", record.arg === ContinueSentinel) continue; return { value: record.arg, done: context.done }; } "throw" === record.type && (state = "completed", context.method = "throw", context.arg = record.arg); } }; } function maybeInvokeDelegate(delegate, context) { var methodName = context.method, method = delegate.iterator[methodName]; if (undefined === method) return context.delegate = null, "throw" === methodName && delegate.iterator.return && (context.method = "return", context.arg = undefined, maybeInvokeDelegate(delegate, context), "throw" === context.method) || "return" !== methodName && (context.method = "throw", context.arg = new TypeError("The iterator does not provide a '" + methodName + "' method")), ContinueSentinel; var record = tryCatch(method, delegate.iterator, context.arg); if ("throw" === record.type) return context.method = "throw", context.arg = record.arg, context.delegate = null, ContinueSentinel; var info = record.arg; return info ? info.done ? (context[delegate.resultName] = info.value, context.next = delegate.nextLoc, "return" !== context.method && (context.method = "next", context.arg = undefined), context.delegate = null, ContinueSentinel) : info : (context.method = "throw", context.arg = new TypeError("iterator result is not an object"), context.delegate = null, ContinueSentinel); } function pushTryEntry(locs) { var entry = { tryLoc: locs[0] }; 1 in locs && (entry.catchLoc = locs[1]), 2 in locs && (entry.finallyLoc = locs[2], entry.afterLoc = locs[3]), this.tryEntries.push(entry); } function resetTryEntry(entry) { var record = entry.completion || {}; record.type = "normal", delete record.arg, entry.completion = record; } function Context(tryLocsList) { this.tryEntries = [{ tryLoc: "root" }], tryLocsList.forEach(pushTryEntry, this), this.reset(!0); } function values(iterable) { if (iterable) { var iteratorMethod = iterable[iteratorSymbol]; if (iteratorMethod) return iteratorMethod.call(iterable); if ("function" == typeof iterable.next) return iterable; if (!isNaN(iterable.length)) { var i = -1, next = function next() { for (; ++i < iterable.length;) if (hasOwn.call(iterable, i)) return next.value = iterable[i], next.done = !1, next; return next.value = undefined, next.done = !0, next; }; return next.next = next; } } return { next: doneResult }; } function doneResult() { return { value: undefined, done: !0 }; } return GeneratorFunction.prototype = GeneratorFunctionPrototype, defineProperty(Gp, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), defineProperty(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, toStringTagSymbol, "GeneratorFunction"), exports.isGeneratorFunction = function (genFun) { var ctor = "function" == typeof genFun && genFun.constructor; return !!ctor && (ctor === GeneratorFunction || "GeneratorFunction" === (ctor.displayName || ctor.name)); }, exports.mark = function (genFun) { return Object.setPrototypeOf ? Object.setPrototypeOf(genFun, GeneratorFunctionPrototype) : (genFun.__proto__ = GeneratorFunctionPrototype, define(genFun, toStringTagSymbol, "GeneratorFunction")), genFun.prototype = Object.create(Gp), genFun; }, exports.awrap = function (arg) { return { __await: arg }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, asyncIteratorSymbol, function () { return this; }), exports.AsyncIterator = AsyncIterator, exports.async = function (innerFn, outerFn, self, tryLocsList, PromiseImpl) { void 0 === PromiseImpl && (PromiseImpl = Promise); var iter = new AsyncIterator(wrap(innerFn, outerFn, self, tryLocsList), PromiseImpl); return exports.isGeneratorFunction(outerFn) ? iter : iter.next().then(function (result) { return result.done ? result.value : iter.next(); }); }, defineIteratorMethods(Gp), define(Gp, toStringTagSymbol, "Generator"), define(Gp, iteratorSymbol, function () { return this; }), define(Gp, "toString", function () { return "[object Generator]"; }), exports.keys = function (val) { var object = Object(val), keys = []; for (var key in object) keys.push(key); return keys.reverse(), function next() { for (; keys.length;) { var key = keys.pop(); if (key in object) return next.value = key, next.done = !1, next; } return next.done = !0, next; }; }, exports.values = values, Context.prototype = { constructor: Context, reset: function reset(skipTempReset) { if (this.prev = 0, this.next = 0, this.sent = this._sent = undefined, this.done = !1, this.delegate = null, this.method = "next", this.arg = undefined, this.tryEntries.forEach(resetTryEntry), !skipTempReset) for (var name in this) "t" === name.charAt(0) && hasOwn.call(this, name) && !isNaN(+name.slice(1)) && (this[name] = undefined); }, stop: function stop() { this.done = !0; var rootRecord = this.tryEntries[0].completion; if ("throw" === rootRecord.type) throw rootRecord.arg; return this.rval; }, dispatchException: function dispatchException(exception) { if (this.done) throw exception; var context = this; function handle(loc, caught) { return record.type = "throw", record.arg = exception, context.next = loc, caught && (context.method = "next", context.arg = undefined), !!caught; } for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i], record = entry.completion; if ("root" === entry.tryLoc) return handle("end"); if (entry.tryLoc <= this.prev) { var hasCatch = hasOwn.call(entry, "catchLoc"), hasFinally = hasOwn.call(entry, "finallyLoc"); if (hasCatch && hasFinally) { if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0); if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc); } else if (hasCatch) { if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0); } else { if (!hasFinally) throw new Error("try statement without catch or finally"); if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc); } } } }, abrupt: function abrupt(type, arg) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.tryLoc <= this.prev && hasOwn.call(entry, "finallyLoc") && this.prev < entry.finallyLoc) { var finallyEntry = entry; break; } } finallyEntry && ("break" === type || "continue" === type) && finallyEntry.tryLoc <= arg && arg <= finallyEntry.finallyLoc && (finallyEntry = null); var record = finallyEntry ? finallyEntry.completion : {}; return record.type = type, record.arg = arg, finallyEntry ? (this.method = "next", this.next = finallyEntry.finallyLoc, ContinueSentinel) : this.complete(record); }, complete: function complete(record, afterLoc) { if ("throw" === record.type) throw record.arg; return "break" === record.type || "continue" === record.type ? this.next = record.arg : "return" === record.type ? (this.rval = this.arg = record.arg, this.method = "return", this.next = "end") : "normal" === record.type && afterLoc && (this.next = afterLoc), ContinueSentinel; }, finish: function finish(finallyLoc) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.finallyLoc === finallyLoc) return this.complete(entry.completion, entry.afterLoc), resetTryEntry(entry), ContinueSentinel; } }, catch: function _catch(tryLoc) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.tryLoc === tryLoc) { var record = entry.completion; if ("throw" === record.type) { var thrown = record.arg; resetTryEntry(entry); } return thrown; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(iterable, resultName, nextLoc) { return this.delegate = { iterator: values(iterable), resultName: resultName, nextLoc: nextLoc }, "next" === this.method && (this.arg = undefined), ContinueSentinel; } }, exports; }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
import Endpoints from "../../Endpoints.js";

// Modal singletons
import BlogReelModal from "../page-editor/modals/BlogReelModal.js";
import IPPReelModal from "../page-editor/modals/IPPReelModal.js";
import RecentArticlesModal from "../page-editor/modals/RecentArticlesModal.js";
import RecentProjectsModal from "../page-editor/modals/RecentProjectsModal.js";

// Forms
import BlogReelForm from "./forms/BlogReelForm.js";
import IPPReelForm from "./forms/IPPReelForm.js";
import RecentArticlesForm from "./forms/RecentArticlesForm.js";
import RecentProjectsForm from "./forms/RecentProjectsForm.js";
var EasyEditor = /*#__PURE__*/function () {
  function EasyEditor(activePageId) {
    _classCallCheck(this, EasyEditor);
    _defineProperty(this, "ActivePageId", void 0);
    _defineProperty(this, "IsProcessing", false);
    _defineProperty(this, "SaveButton", document.querySelector('.btn-success.btn-sm[type="submit"][form="page-edit-form"]'));
    this.ActivePageId = activePageId;
    this.Initialize();
  }
  _createClass(EasyEditor, [{
    key: "Initialize",
    value: function () {
      var _Initialize = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
        var _this = this;
        var _yield$this$GetPhoneA, _yield$this$GetPhoneA2, phoneNumbers, faxNumbers;
        return _regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return this.GetPhoneAndFaxNumbers();
            case 2:
              _yield$this$GetPhoneA = _context.sent;
              _yield$this$GetPhoneA2 = _slicedToArray(_yield$this$GetPhoneA, 2);
              phoneNumbers = _yield$this$GetPhoneA2[0];
              faxNumbers = _yield$this$GetPhoneA2[1];
              tinymce.init({
                selector: '#content-editor-container',
                width: '100%',
                promotion: false,
                statusbar: false,
                browser_spellcheck: true,
                plugins: 'table link lists',
                toolbar: 'undo redo | blocks | bold italic | alignleft aligncentre alignright alignjustify | indent outdent | bullist numlist',
                skin: 'tinymce-5',
                menu: {
                  shortcodes: {
                    title: 'Shortcodes',
                    items: 'phoneNumbers faxNumbers companyName companyStreet companyPostal companyCity companyState blogReel ippReel recentArticles recentProjects reviews'
                  }
                },
                menubar: 'edit view insert format shortcodes',
                setup: function setup(editor) {
                  editor.ui.registry.addNestedMenuItem('phoneNumbers', {
                    text: 'Phone Numbers',
                    getSubmenuItems: function getSubmenuItems() {
                      return phoneNumbers.map(function (phoneNumber, index) {
                        return {
                          type: 'menuitem',
                          text: phoneNumber,
                          onAction: function onAction() {
                            return editor.insertContent(_this.GetPhoneNumbersShortcodeValue(index));
                          }
                        };
                      });
                    }
                  });
                  editor.ui.registry.addNestedMenuItem('faxNumbers', {
                    text: 'Fax Numbers',
                    getSubmenuItems: function getSubmenuItems() {
                      return faxNumbers.map(function (faxNumber, index) {
                        return {
                          type: 'menuitem',
                          text: faxNumber,
                          onAction: function onAction() {
                            return editor.insertContent(_this.GetFaxNumbersShortcodeValue(index));
                          }
                        };
                      });
                    }
                  });
                  new BlogReelForm(editor);
                  new IPPReelForm(editor);
                  new RecentArticlesForm(editor);
                  new RecentProjectsForm(editor);
                  var addMenuItem = function addMenuItem(name, text, action) {
                    editor.ui.registry.addMenuItem(name, {
                      text: text,
                      onAction: action
                    });
                  };
                  addMenuItem('companyName', 'Company Name', function () {
                    return editor.insertContent(_this.GetCompanyNameShortcodeValue());
                  });
                  addMenuItem('companyStreet', 'Company Street', function () {
                    return editor.insertContent(_this.GetCompanyStreetShortcodeValue());
                  });
                  addMenuItem('companyPostal', 'Company Postal', function () {
                    return editor.insertContent(_this.GetCompanyPostalShortcodeValue());
                  });
                  addMenuItem('companyCity', 'Company City', function () {
                    return editor.insertContent(_this.GetCompanyCityShortcodeValue());
                  });
                  addMenuItem('companyState', 'Company State', function () {
                    return editor.insertContent(_this.GetCompanyStateShortcodeValue());
                  });
                  addMenuItem('blogReel', 'Blog Reel', function () {
                    return BlogReelModal.showModal();
                  });
                  addMenuItem('ippReel', 'IPP Reel', function () {
                    return IPPReelModal.showModal();
                  });
                  addMenuItem('recentArticles', 'Recent Articles', function () {
                    return RecentArticlesModal.showModal();
                  });
                  addMenuItem('recentProjects', 'Recent Projects', function () {
                    return RecentProjectsModal.showModal();
                  });
                  addMenuItem('reviews', 'Reviews', function () {
                    return editor.insertContent(_this.GetReviewsShortcodeValue());
                  });
                  editor.addShortcut('ctrl+s', "Save page", function () {
                    editor.save();
                    _this.SavePage();
                  });
                }
              });

              // Handle saving
              this.SaveButton.addEventListener("click", function () {
                _this.SavePage();
              });
              window.addEventListener("keydown", function (e) {
                if (e.ctrlKey && e.key === "s") {
                  e.preventDefault();
                  e.stopPropagation();
                  _this.SavePage();
                }
              });
            case 9:
            case "end":
              return _context.stop();
          }
        }, _callee, this);
      }));
      function Initialize() {
        return _Initialize.apply(this, arguments);
      }
      return Initialize;
    }()
  }, {
    key: "GetPhoneAndFaxNumbers",
    value: function () {
      var _GetPhoneAndFaxNumbers = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee2() {
        var response, data;
        return _regeneratorRuntime().wrap(function _callee2$(_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              _context2.next = 2;
              return fetch("".concat(Endpoints.easyEditor.getPhoneAndFaxNumbers), {
                cache: "no-cache",
                credentials: "same-origin",
                method: "get"
              });
            case 2:
              response = _context2.sent;
              _context2.next = 5;
              return response.json();
            case 5:
              data = _context2.sent;
              return _context2.abrupt("return", [data.phoneNumbers, data.faxNumbers]);
            case 7:
            case "end":
              return _context2.stop();
          }
        }, _callee2);
      }));
      function GetPhoneAndFaxNumbers() {
        return _GetPhoneAndFaxNumbers.apply(this, arguments);
      }
      return GetPhoneAndFaxNumbers;
    }()
  }, {
    key: "GetPhoneNumbersShortcodeValue",
    value: function GetPhoneNumbersShortcodeValue(index) {
      // We add 1 to the index since starting at 0 seemed like it might confuse users
      return "{{ phone-number which='".concat(index + 1, "' }}");
    }
  }, {
    key: "GetFaxNumbersShortcodeValue",
    value: function GetFaxNumbersShortcodeValue(index) {
      // We add 1 to the index since starting at 0 seemed like it might confuse users
      return "{{ fax-number which='".concat(index + 1, "' }}");
    }
  }, {
    key: "GetCompanyNameShortcodeValue",
    value: function GetCompanyNameShortcodeValue() {
      return '{{ company-name }}';
    }
  }, {
    key: "GetCompanyStreetShortcodeValue",
    value: function GetCompanyStreetShortcodeValue() {
      return '{{ company-street }}';
    }
  }, {
    key: "GetCompanyPostalShortcodeValue",
    value: function GetCompanyPostalShortcodeValue() {
      return '{{ company-postal }}';
    }
  }, {
    key: "GetCompanyCityShortcodeValue",
    value: function GetCompanyCityShortcodeValue() {
      return '{{ company-city }}';
    }
  }, {
    key: "GetCompanyStateShortcodeValue",
    value: function GetCompanyStateShortcodeValue() {
      return '{{ company-state }}';
    }
  }, {
    key: "GetReviewsShortcodeValue",
    value: function GetReviewsShortcodeValue() {
      return '{{ get-reviews columns="1" truncate-body="false" limit="100" offset="0" city="" state="" schema="true" show-empty-message="true" show-header="true" }}';
    }
  }, {
    key: "SavePage",
    value: function () {
      var _SavePage = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee3() {
        var formData, response;
        return _regeneratorRuntime().wrap(function _callee3$(_context3) {
          while (1) switch (_context3.prev = _context3.next) {
            case 0:
              if (!this.IsProcessing) {
                _context3.next = 2;
                break;
              }
              return _context3.abrupt("return");
            case 2:
              this.IsProcessing = true;
              this.SaveButton.classList.add("disabled");
              formData = new FormData();
              formData.set("content", tinymce.get('content-editor-container').getContent());
              _context3.next = 8;
              return fetch("".concat(Endpoints.easyEditor.savePage, "/").concat(this.ActivePageId), {
                body: formData,
                cache: "no-cache",
                credentials: "same-origin",
                method: "POST"
              });
            case 8:
              response = _context3.sent;
              if (response.status !== 200) {
                console.error("An error occurred while saving this page. Please contact a developer.");
              } else {
                console.log("success");
              }
              this.IsProcessing = false;
              this.SaveButton.classList.remove("disabled");
            case 12:
            case "end":
              return _context3.stop();
          }
        }, _callee3, this);
      }));
      function SavePage() {
        return _SavePage.apply(this, arguments);
      }
      return SavePage;
    }()
  }, {
    key: "ChangePage",
    value: function ChangePage(pageData) {
      this.ActivePageId = pageData.id;
      tinymce.get('content-editor-container').setContent(pageData.pageBody);
    }
  }]);
  return EasyEditor;
}();
export { EasyEditor as default };