function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
* Utility class to help get sets of DOM nodes
* for the page editor or the file editor
*/
var DOMHelper = /*#__PURE__*/function () {
  function DOMHelper() {
    _classCallCheck(this, DOMHelper);
  }
  return _createClass(DOMHelper, null, [{
    key: "getAllPageEditorTabs",
    value:
    /**
    * Gets all the editor tab DOMS on the page editor view
    * @returns {object}
    */
    function getAllPageEditorTabs() {
      return {
        body: document.querySelector(".editor-tab[data-window=\"body\"]"),
        head: document.querySelector(".editor-tab[data-window=\"head\"]"),
        data: document.querySelector(".editor-tab[data-window=\"data\"]")
      };
    }

    /**
    * Gets all the ace editors on the theme editor view
    * @returns {object}
    */
  }, {
    key: "getThemeManagerAceEditors",
    value: function getThemeManagerAceEditors() {
      return {
        file: ace.edit(document.querySelector("#file-content"))
      };
    }

    /**
    * Gets the currently active theme manager tab
    * @returns {HTMLButtonElement}
    */
  }, {
    key: "getActiveThemeManagerTab",
    value: function getActiveThemeManagerTab() {
      return document.querySelector(".editor-tab.selected");
    }

    /**
    * Gets all the page windows on the page editor view
    * @returns {{body: HTMLElement, bodySections: HTMLElement, head: HTMLElement, data: HTMLElement}}
    */
  }, {
    key: "getAllPageEditorWindows",
    value: function getAllPageEditorWindows() {
      return {
        body: document.querySelector("#page-content"),
        bodySections: document.querySelector("#page-sections-content-container"),
        head: document.querySelector("#page-head"),
        data: document.querySelector("#page-data")
      };
    }
  }]);
}();
export default DOMHelper;