function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
import LinkContextMenu from "./LinkContextMenu.js";

/**
* Loads Ace Editor extensions and default
* properties.
*/
var AceEditorExtension = /*#__PURE__*/function () {
  /**
   * @param {HTMLElement} element
   * @param {?string} defaultLanguage
   */
  function AceEditorExtension(element, defaultLanguage) {
    var _this = this;
    _classCallCheck(this, AceEditorExtension);
    this.ace = ace.edit(element);
    this.session = this.ace.getSession();
    this.aceContainer = element;
    this.currentLinkContextMenu = null;

    /*
    	You can set the default language of an ace editor
    	by adding ace-lang="html" to the div/container
    	that the ace editor will be on
    */
    if (this.aceContainer.getAttribute("ace-lang") !== null) {
      this.aceLanguage = this.aceContainer.getAttribute("ace-lang");
    }

    // Set defaults

    this.ace.setHighlightActiveLine(true);
    //editor.setTheme("ace/theme/textmate");
    this.ace.setOption("showPrintMargin", false);
    this.ace.setFontSize(14);
    this.ace.setOptions({
      scrollPastEnd: 0.4
    });
    this.ace.setWrapBehavioursEnabled(true);
    this.ace.setBehavioursEnabled(false); // Stop the annoying stupid auto-closing tags

    AceEditorExtension.setSessionDefaults(this.session, defaultLanguage);

    // editor.commands.addCommand({
    // 	name: 'saveFile',
    // 	bindKey: {
    // 		win: 'Ctrl-S',
    // 		mac: 'Command-S',
    // 		sender: 'editor|cli'
    // 	},
    // 	exec: function(env, args, request) {
    // 		$(v).trigger("save-command", [editor]);
    // 	}
    // });

    // Fix ace editor not being resized when content is pasted
    this.ace.on("paste", function () {
      setTimeout(function () {
        _this.ace.resize(true);
      });
    });
  }

  /**
   * Loads all custom defined methods of AceEditorExtension for this instance
   */
  return _createClass(AceEditorExtension, [{
    key: "loadExtensions",
    value: function loadExtensions() {
      this.loadHighlightInnerTag();
      this.loadLinkize();
      this.loadBold();
      this.loadParagraphize();
      this.loadLinkContextMenu();
      this.loadPasteFormatter();
    }

    /**
    * Load a command that will allow Ctrl + p to
    * wrap text into paragraph tags
    */
  }, {
    key: "loadParagraphize",
    value: function loadParagraphize() {
      var aceEditor = this.ace;
      aceEditor.commands.addCommand({
        name: "Paragraphize",
        exec: function exec() {
          var selectionRange = aceEditor.getSelectionRange();
          var currentlySelectedText = aceEditor.getSelectedText();
          var tabStartCheck = currentlySelectedText.match(/^\t+/);
          var startsWithTabs = tabStartCheck !== null;
          var tabPadding = "";
          var newString = ""; // A buffer of the paragraphized string

          if (startsWithTabs) {
            tabPadding = tabStartCheck[0];
          }
          if (currentlySelectedText.length > 0) {
            var endText = "\n" + tabPadding + "</p>";
            var startString = tabPadding + "<p>\n" + tabPadding;
            var injectedIndent = "";
            if (tabPadding.length === 0) {
              // Editor will not auto-insert a tab if there was not one originally
              // So inject it manually
              injectedIndent = "\t";
              startString += injectedIndent;
            }

            // Separate the string by sections
            // Delimited by multiple new lines
            var stringParts = currentlySelectedText.split("\n\n");
            var counter = 0;
            var _iterator = _createForOfIteratorHelper(stringParts),
              _step;
            try {
              for (_iterator.s(); !(_step = _iterator.n()).done;) {
                var part = _step.value;
                newString += startString;
                newString += part.trim();
                newString += endText;
                if (counter !== stringParts.length - 1) {
                  // Not the last index
                  newString += "\n";
                }
                ++counter;
              }
            } catch (err) {
              _iterator.e(err);
            } finally {
              _iterator.f();
            }
            aceEditor.session.replace(selectionRange, newString);
          }
        },
        bindKey: {
          mac: "cmd-p",
          win: "ctrl-p"
        }
      });
    }

    /**
    * Adds bold command to ace editor with Ctrl + B
    */
  }, {
    key: "loadBold",
    value: function loadBold() {
      var aceEditor = this.ace;
      var AceRange = ace.require("ace/range").Range;
      aceEditor.commands.addCommand({
        name: "Bold Text",
        exec: function exec() {
          var selectionRange = aceEditor.getSelectionRange();
          if (aceEditor.getSelectedText().length > 0) {
            aceEditor.session.insert(selectionRange.start, "<strong>");
            aceEditor.session.insert(aceEditor.getSelectionRange().end, "</strong>");

            // Reset the range to remove the now-selected </strong>
            var currentSelectionRange = aceEditor.getSelectionRange();
            var newSelectionEndPositionRow = currentSelectionRange.end.row;
            var newSelectionEndPositionColumn = currentSelectionRange.end.column - "</strong>".length;
            if (newSelectionEndPositionColumn < 0) {
              // Go up a row
              newSelectionEndPositionRow -= 1;
              newSelectionEndPositionColumn = aceEditor.getSession().doc.getAllLines()[newSelectionEndPositionRow].length + newSelectionEndPositionColumn;
            }
            aceEditor.session.selection.setSelectionRange(new AceRange(currentSelectionRange.start.row, currentSelectionRange.start.column, newSelectionEndPositionRow, newSelectionEndPositionColumn));
          }
        },
        bindKey: {
          mac: "cmd-b",
          win: "ctrl-b"
        }
      });
    }

    /**
    * Command to wrap a text in a link/anchor using Ctrl + L
    */
  }, {
    key: "loadLinkize",
    value: function loadLinkize() {
      var aceEditor = this.ace;
      var AceRange = ace.require("ace/range").Range;
      aceEditor.commands.addCommand({
        name: "Link text",
        exec: function exec() {
          var selectionRange = aceEditor.getSelectionRange();
          if (aceEditor.getSelectedText().length > 0) {
            aceEditor.session.insert(selectionRange.start, "<a href=\"#link\">");
            aceEditor.session.insert(aceEditor.getSelectionRange().end, "</a>");

            // Reset the range to remove the now-selected </strong>
            var currentSelectionRange = aceEditor.getSelectionRange();
            var newSelectionEndPositionRow = currentSelectionRange.end.row;
            var newSelectionEndPositionColumn = currentSelectionRange.end.column - "</a>".length;
            if (newSelectionEndPositionColumn < 0) {
              // Go up a row
              newSelectionEndPositionRow -= 1;
              newSelectionEndPositionColumn = aceEditor.getSession().doc.getAllLines()[newSelectionEndPositionRow].length + newSelectionEndPositionColumn;
            }
            aceEditor.session.selection.setSelectionRange(new AceRange(currentSelectionRange.start.row, currentSelectionRange.start.column, newSelectionEndPositionRow, newSelectionEndPositionColumn));
          }
        },
        bindKey: {
          mac: "cmd-l",
          win: "ctrl-l"
        }
      });
    }

    /**
    * Press Ctrl + Right Clicking inside of an HTML tag
    * will cause everything in between the < and > to be
    * highlighted/selected
    */
  }, {
    key: "loadHighlightInnerTag",
    value: function loadHighlightInnerTag() {
      var aceEditor = this.ace;
      var AceRange = ace.require("ace/range").Range;
      aceEditor.container.addEventListener("contextmenu", function (e) {
        if (e.ctrlKey === true) {
          e.preventDefault();
          var thisSession = aceEditor.getSession();
          var thisDocument = thisSession.doc;
          var allLines = thisDocument.getAllLines();
          var lastLineNumber = allLines.length - 1; // Last row possible
          var lastColumnOnLastLine = allLines[lastLineNumber].length; // Last column on last line

          // Get cursor position in ace editor
          var cursorPosition = aceEditor.getCursorPosition(); // Gives an object with `row`, `column` keys

          // Move forward until an ending bracket is met
          var currentForwardRow = cursorPosition.row;
          var currentForwardColumn = cursorPosition.column;
          var maxForwardColumn = allLines[currentForwardRow].length;
          var forwardEndRow;
          var forwardEndColumn;
          while (1 == 1 && 2 !== 3) {
            // Increment check
            if (maxForwardColumn === currentForwardColumn) {
              if (currentForwardRow < lastLineNumber) {
                // Move to the next line
                ++currentForwardRow;
                currentForwardColumn = 0;
                maxForwardColumn = allLines[currentForwardRow].length;
              } else {
                // Hit the end
                break;
              }
            }
            var currentCharacterRange = new AceRange(currentForwardRow, currentForwardColumn, currentForwardRow, currentForwardColumn + 1);
            var currentCharacter = thisSession.getTextRange(currentCharacterRange);
            if (currentCharacter === ">") {
              forwardEndRow = currentForwardRow;
              forwardEndColumn = currentForwardColumn;
              break;
            }
            ++currentForwardColumn;
          }

          // Move backward until an opening bracket is met
          var currentBackwardRow = cursorPosition.row;
          var currentBackwardColumn = cursorPosition.column;
          var backwardEndRow;
          var backwardEndColumn;
          while (1 == 1 && 2 !== 3) {
            // Increment check
            if (0 === currentBackwardColumn) {
              if (currentBackwardRow > 0) {
                // Move to the prior line
                --currentBackwardRow;
                currentBackwardColumn = allLines[currentBackwardRow].length;
              } else {
                // Hit the end
                break;
              }
            }
            var _currentCharacterRange = new AceRange(currentBackwardRow, currentBackwardColumn - 1, currentBackwardRow, currentBackwardColumn);
            var _currentCharacter = thisSession.getTextRange(_currentCharacterRange);
            if (_currentCharacter === "<") {
              backwardEndRow = currentBackwardRow;
              backwardEndColumn = currentBackwardColumn;
              break;
            } else if (_currentCharacter === ">") {
              break;
            }
            --currentBackwardColumn;
          }
          if (backwardEndRow !== undefined && forwardEndRow !== undefined) {
            // Found locations
            // Select it
            // -1 and +1 to include the brackets
            var tagRange = new AceRange(backwardEndRow, backwardEndColumn - 1, forwardEndRow, forwardEndColumn + 1);
            thisSession.selection.setSelectionRange(tagRange);
          }
        }
      });
    }

    /**
    * Loads the HTML parser for pastes that are not raw-paste
    */
  }, {
    key: "loadPasteFormatter",
    value: function loadPasteFormatter() {
      var aceEditor = this.ace;
      aceEditor.commands.on("exec", function (e) {
        var command = e.command;

        // Capture the paste event before it adds text
        // onPaste and .on("paste") fire too late
        // So using "exec" and capturing the event here allows
        // preventDefault() to actually work
        if (command.name === "paste") {
          var originalEvent = e.args.event;
          var html = originalEvent.clipboardData.getData("text/html");
          var fragmentMatch = html.match(new RegExp("<!--StartFragment-->(.+)<!--EndFragment-->"));
          if (fragmentMatch !== null) {
            e.preventDefault();
            var rawHtml = fragmentMatch[1];
            var unstyledHtml = rawHtml.replace(/ style="[^"<>]+"/g, "");
            var unclassedHtml = unstyledHtml.replace(/ class="[^"<>]+"/g, "");

            // Remove empty span elements
            var spaceFixedHtml = unclassedHtml.replace(/<span>\s*<\/span>/g, " ");

            // Add newlines and a tab to paragraphs
            spaceFixedHtml = spaceFixedHtml.replace(/<p>/g, "<p>\n\t");
            spaceFixedHtml = spaceFixedHtml.replace(/<\/p>/g, "\n</p>\n");

            // Add proper newline to headings
            spaceFixedHtml = spaceFixedHtml.replace(/<\/h([0-9])>/g, "</h$1>\n");

            // Format unordered and ordered lists
            spaceFixedHtml = spaceFixedHtml.replace(/<([uo])l>/g, "<$1l>\n");
            spaceFixedHtml = spaceFixedHtml.replace(/<\/([uo])l>/g, "</$1l>\n");

            // Remove div tags
            spaceFixedHtml = spaceFixedHtml.replace(/<div>/g, "");
            spaceFixedHtml = spaceFixedHtml.replace(/<\/div>/g, "");

            // Remove <br> breaks
            spaceFixedHtml = spaceFixedHtml.replace(/<br.*>\n*/g, "");
            spaceFixedHtml = spaceFixedHtml.replace(/<\/br.*>\n*/g, "");
            spaceFixedHtml = spaceFixedHtml.replace(/<\/li>/g, "</li>\n");
            spaceFixedHtml = spaceFixedHtml.replace(/<li>/g, "\t<li>");

            // Remove links and replace them with #link
            spaceFixedHtml = spaceFixedHtml.replace(/href=".*?"/g, "href=\"#link\"");
            aceEditor.insert(spaceFixedHtml.trim());
          }
        }
      });
    }

    /**
    * Loads the right-click link menu feature.
    * Only works if the cursor is in between href attribute quotes.
    */
  }, {
    key: "loadLinkContextMenu",
    value: function loadLinkContextMenu() {
      var _this2 = this;
      var aceEditor = this.ace;
      var AceRange = ace.require("ace/range").Range;
      aceEditor.container.addEventListener("contextmenu", function (e) {
        var loopLimit = 20000;
        var numLoops = 0;
        var thisSession = aceEditor.getSession();
        var thisDocument = thisSession.doc;
        var allLines = thisDocument.getAllLines();
        var lastLineNumber = allLines.length - 1; // Last row possible
        var lastColumnOnLastLine = allLines[lastLineNumber].length; // Last column on last line

        // Only show the modal if the selection is empty
        if (!thisSession.getSelection().isEmpty()) {
          return;
        }

        // Get cursor position in ace editor
        var cursorPosition = aceEditor.getCursorPosition(); // Gives an object with `row`, `column` keys

        // Move forward until an ending bracket is met
        var currentForwardRow = cursorPosition.row;
        var currentForwardColumn = cursorPosition.column;
        var maxForwardColumn = allLines[currentForwardRow].length;
        var forwardEndRow;
        var forwardEndColumn;
        var forwardBuffer = "";
        var backwardBuffer = "";

        // Keep moving forward until a quotation is hit
        while (1 == 1 && 2 == 2 && 3 == 3 && "john" != "henrik") {
          if (numLoops >= loopLimit) {
            break;
          }
          ++numLoops;

          // Increment check
          if (maxForwardColumn === currentForwardColumn) {
            if (currentForwardRow < lastLineNumber) {
              // Move to the next line
              ++currentForwardRow;
              currentForwardColumn = 0;
              maxForwardColumn = allLines[currentForwardRow].length;
            } else {
              // Hit the end
              break;
            }
          }
          var _currentCharacterRange2 = new AceRange(currentForwardRow, currentForwardColumn, currentForwardRow, currentForwardColumn + 1);
          var _currentCharacter2 = thisSession.getTextRange(_currentCharacterRange2);
          if (_currentCharacter2 !== "\"") {
            forwardBuffer += _currentCharacter2;
          } else {
            // Found a quote. Done moving forward
            break;
          }
          ++currentForwardColumn;
        }

        // Move backwards until hitting a quote
        var currentBackwardRow = cursorPosition.row;
        var currentBackwardColumn = cursorPosition.column;
        var backwardEndRow;
        var backwardEndColumn;
        while (1 == 1 && 2 !== 3) {
          if (numLoops >= loopLimit) {
            break;
          }
          ++numLoops;

          // Increment check
          if (0 === currentBackwardColumn) {
            if (currentBackwardRow > 0) {
              // Move to the prior line
              --currentBackwardRow;
              currentBackwardColumn = allLines[currentBackwardRow].length;
            } else {
              // Hit the end
              break;
            }
          }
          var _currentCharacterRange3 = new AceRange(currentBackwardRow, currentBackwardColumn - 1, currentBackwardRow, currentBackwardColumn);
          var _currentCharacter3 = thisSession.getTextRange(_currentCharacterRange3);
          if (_currentCharacter3 !== "\"") {
            backwardBuffer += _currentCharacter3;
          } else {
            // Found a quote. Done moving backward
            break;
          }
          --currentBackwardColumn;
        }
        var beforeInnerTextForwardsRow = parseInt(currentForwardRow, 10);
        var beforeInnerTextForwardsColumn = parseInt(currentForwardColumn, 10);

        // Check the character before the last backwards character
        // Is it an = (equal sign)?
        // That means an attribute was probably being set. Yay
        var currentCharacterRange = new AceRange(currentBackwardRow, currentBackwardColumn - 2, currentBackwardRow, currentBackwardColumn - 1);
        var currentCharacter = thisSession.getTextRange(currentCharacterRange);
        if (currentCharacter === "=") {
          // Go back 4 more charatcters
          // Is it an href?
          var _currentCharacterRange4 = new AceRange(currentBackwardRow, currentBackwardColumn - 6, currentBackwardRow, currentBackwardColumn - 2);
          var currentMatchSet = thisSession.getTextRange(_currentCharacterRange4);
          if (currentMatchSet === "href") {
            e.preventDefault();
            var innerAnchorText = "";
            var currentParseState = "in-attributes";

            // Get the inner content of the anchor
            while (true) {
              if (numLoops >= loopLimit) {
                break;
              }
              ++numLoops;

              // Increment check
              if (maxForwardColumn === currentForwardColumn) {
                if (currentForwardRow < lastLineNumber) {
                  // Move to the next line
                  ++currentForwardRow;
                  currentForwardColumn = 0;
                  maxForwardColumn = allLines[currentForwardRow].length;
                } else {
                  // Hit the end
                  break;
                }
              }
              var _currentCharacterRange5 = new AceRange(currentForwardRow, currentForwardColumn, currentForwardRow, currentForwardColumn + 1);
              var _currentCharacter4 = thisSession.getTextRange(_currentCharacterRange5);
              if (currentParseState == "in-attributes") {
                if (_currentCharacter4 === ">") {
                  currentParseState = "text-content";
                }
              } else if (currentParseState === "text-content") {
                if (_currentCharacter4 === "<") {
                  break; // Done parsing
                } else {
                  innerAnchorText += _currentCharacter4;
                }
              }
              ++currentForwardColumn;
            }

            // Show the link modal
            if (_this2.currentLinkContextMenu !== null) {
              _this2.currentLinkContextMenu.cleanup();
            }
            var cm = new LinkContextMenu(document.body, e.pageX, e.pageY, innerAnchorText);
            var replacementRange = new AceRange(currentBackwardRow, currentBackwardColumn, beforeInnerTextForwardsRow, beforeInnerTextForwardsColumn);
            // cm.performSearch();
            cm.onPageSelected(function (pageName, pageRoute) {
              thisSession.replace(replacementRange, pageRoute);
              thisSession.selection.setSelectionRange(new AceRange(currentBackwardRow, currentBackwardColumn, currentBackwardRow, currentBackwardColumn + pageRoute.length));
              cm.cleanup();
            });
            _this2.currentLinkContextMenu = cm;
          }
        }
      });
    }

    /**
     * @param {ImageComponent} imageComponent
     * @return {HTMLPictureElement}
     */
  }, {
    key: "getImageComponent",
    value: function getImageComponent(imageComponent) {
      var template = document.createElement("picture");
      var img = document.createElement("img");
      if (imageComponent.fileExtension !== "webp") {
        img.setAttribute("src", imageComponent.uri);
        img.setAttribute("alt", imageComponent.tryToCreateAlt());
        img.setAttribute("class", "");
        template.append(img);
      } else {
        // This is a WebP, so also insert the fallback URI. If none exists, then warn the user.
        if (imageComponent.fallbackImage !== null) {
          /** @type {{fileExtension: string, fileName: string, fileNameWithoutExtension: string, uri: string, thumbURI: string}} */
          var fallbackImage = imageComponent.fallbackImage;
          var sourceElement = document.createElement("source");
          var fileSourceType = "image/webp";
          sourceElement.setAttribute("type", fileSourceType);
          sourceElement.setAttribute("srcset", imageComponent.uri);
          img.setAttribute("src", fallbackImage.uri);
          img.setAttribute("alt", imageComponent.tryToCreateAlt());
          img.setAttribute("class", "");
          template.append(sourceElement);
          template.append(img);
        } else {
          alert("You are inserting a WebP image and have not made a fallback PNG or JPEG. It is highly recommended you clone the WebP and convert it to a JPEG or PNG image for older iOS devices that do not support WebP.");
          img.setAttribute("src", imageComponent.uri);
          img.setAttribute("alt", imageComponent.tryToCreateAlt());
          img.setAttribute("class", "");
          template.append(img);
        }
      }
      return template;
    }

    /**
     * Returns all whitespace (tabs or spaces) on the current line before
     * the first non-whitespace is hit.
     * @return {string}
     */
  }, {
    key: "getAllWhitespaceCharactersStartingLine",
    value: function getAllWhitespaceCharactersStartingLine() {
      /**
       * Get the cursor's current row/column position
       * @type {{row: int, column: int}}
       */
      var cursorPosition = this.ace.getSession().getSelection().getCursor();
      var textOnLine = this.ace.getSession().getLine(cursorPosition.row);
      var buffer = "";
      var _iterator2 = _createForOfIteratorHelper(textOnLine),
        _step2;
      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var char = _step2.value;
          if (char !== "\t" && char !== " ") {
            break;
          } else {
            buffer += char;
          }
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }
      return buffer;
    }

    /**
     * When ImageComponents are selected to be inserted from the editor.
     * @param {ImageComponent[]} imageComponents
     */
  }, {
    key: "insertImages",
    value: function insertImages(imageComponents) {
      var _iterator3 = _createForOfIteratorHelper(imageComponents),
        _step3;
      try {
        for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
          var component = _step3.value;
          var element = this.getImageComponent(component);

          // Get the whitespace (space or tab) starting the line
          var whitespaceStartingLineCursorIsOne = this.getAllWhitespaceCharactersStartingLine();

          // Add newlines and tabs
          var outerHTML = element.outerHTML;
          var formattedHTML = outerHTML.replace("<picture>", "<picture>\n").replace(/<source(.+?)>/, "".concat(whitespaceStartingLineCursorIsOne, "\t<source$1>\n")).replace("<img", "".concat(whitespaceStartingLineCursorIsOne, "\t<img")).replace("</picture>", "\n".concat(whitespaceStartingLineCursorIsOne, "</picture>\n"));
          this.ace.insert(formattedHTML);
          if (imageComponents.length === 1) {
            // Find the last occurrence of class="" - which is inserted with the <img> element HTML
            /** @type {{start: {row: int, column: int}, end: {row: int, column: int}} | undefined}} */
            var findResult = this.ace.find("class=\"\"", {
              backwards: true
            }, false);
            if (findResult !== undefined) {
              this.ace.moveCursorTo(findResult.end.row, findResult.end.column - 1);
              this.ace.clearSelection();
              this.ace.focus();
            }
          }
        }
      } catch (err) {
        _iterator3.e(err);
      } finally {
        _iterator3.f();
      }
    }
  }], [{
    key: "setSessionDefaults",
    value:
    /**
     * Set common defaults for the Ace Session
     * @param aceSession
     * @param {string|null} defaultLanguage
     */
    function setSessionDefaults(aceSession, defaultLanguage) {
      aceSession.setUseSoftTabs(false);
      aceSession.setTabSize(4);
      aceSession.setUseWrapMode(true);
      if (defaultLanguage !== null) {
        aceSession.setMode("ace/mode/" + defaultLanguage);
      }

      // Disable the DOCTYPE notification
      aceSession.on("changeAnnotation", function () {
        var annotations = aceSession.getAnnotations() || [];
        var len = annotations.length;
        var i = len;
        while (i--) {
          if (/doctype first\. Expected/.test(annotations[i].text)) {
            annotations.splice(i, 1);
          }
        }
        if (len > annotations.length) {
          aceSession.setAnnotations(annotations);
        }
      });
    }
  }]);
}();
_defineProperty(AceEditorExtension, "pageEditors", {
  /**
   * The body editor here will be null for layouts that have
   * no PageLayoutSectionsDefinition object
   */
  body: null,
  head: null
});
export default AceEditorExtension;