var _ImageComponent;
function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
var ImageComponent = /*#__PURE__*/function () {
  function ImageComponent() {
    _classCallCheck(this, ImageComponent);
    /** @type {?HTMLDivElement} */
    _defineProperty(this, "dom", null);
    /** @type {?HTMLDivElement} */
    _defineProperty(this, "uploadContainerDOM", null);
    _defineProperty(this, "isDragging", false);
    _defineProperty(this, "currentDraggingYOffsetFromMouse", 0);
    this.id = ++ImageComponent.internalCounter;
    this.dom = this.getDOM();
    this.uploadContainerDOM = this.dom.querySelector(".client-project-form-fake-upload-container");
    ImageComponent.cache.push(this);
  }
  return _createClass(ImageComponent, [{
    key: "remove",
    value: function remove() {
      ImageComponent.removeFromCacheByID(this.id);
      this.dom.remove();
    }
  }, {
    key: "getDOM",
    value: function getDOM() {
      var _this = this;
      var template = document.createElement("div");
      template.classList.add("client-project-form-upload-wrapper");
      template.innerHTML = "\n\t\t\t<div class=\"client-project-form-fake-upload-container\">\n\t\t\t\t<div class=\"move-handles-container\">\n\t\t\t\t\t<button type=\"button\" class=\"move-handle\">\n\t\t\t\t\t\t<i class=\"bi bi-arrows-move\"></i>\n\t\t\t\t\t</button>\n\t\t\t\t</div>\n\t\t\t\t<div class=\"input-container\">\n\t\t\t\t\t<input accept=\".jpeg,.jpg,.png,.gif,.webp,.heic\" type=\"file\" id=\"additional-image-".concat(this.id, "\">\n\t\t\t\t\t<label for=\"additional-image-").concat(this.id, "\"></label>\n\t\t\t\t</div>\n\t\t\t\t<div class=\"buttons-container\">\n\t\t\t\t\t<button type=\"button\" class=\"remove-button btn btn-sm btn-danger\">\n\t\t\t\t\t\t<i class=\"bi bi-trash-fill\"></i>\n\t\t\t\t\t\t<span>Remove Image</span>\n\t\t\t\t\t</button>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t");
      var dragHandle = template.querySelector(".move-handle");
      var removeButton = template.querySelector(".remove-button");
      var fileInput = template.querySelector(".input-container input");
      removeButton.addEventListener("click", function () {
        _this.remove();
      });
      fileInput.addEventListener("change", /** @param {InputEvent} e */function (e) {
        _this.onFileInputChanged(fileInput, e);
      });
      dragHandle.addEventListener("mousedown", /** @param {MouseEvent} e */function (e) {
        _this.startDrag(e.pageY);
      });
      dragHandle.addEventListener("touchstart", /** @param {TouchEvent} e */function (e) {
        /** @type {Touch} */
        var firstTouch = e.touches[0];
        if (firstTouch) {
          _this.startDrag(firstTouch.pageY);
        }
      }, {
        passive: false
      });
      ImageComponent.componentsContainer.prepend(template);
      return template;
    }

    /**
     * @param {HTMLInputElement} inputElement
     * @param {InputEvent} event
     */
  }, {
    key: "onFileInputChanged",
    value: function onFileInputChanged(inputElement, event) {
      var file = inputElement.files[0];
      var maxFileSizeInBytes = parseInt(document.querySelector("#max-file-upload-size").getAttribute("data-in-bytes"));
      if (file) {
        // Don't let files be 95% max file size
        var paddedMaxFileSizeInBytes = 0.95 * maxFileSizeInBytes;
        var fileSize = file.size;
        if (fileSize >= paddedMaxFileSizeInBytes) {
          alert("That file is too large and cannot be submitted. We have removed it. Please optimize or resize that file to submit it.");
          inputElement.value = null;
        } else {
          // It's good
        }
      }
    }
  }, {
    key: "startDrag",
    value: function startDrag(pageY) {
      var boundingRectsOfDOM = this.uploadContainerDOM.getBoundingClientRect();
      var boundingRectsOfContainer = ImageComponent.componentsContainer.getBoundingClientRect();
      var leftOffset = boundingRectsOfContainer.left;

      // How many pixels is the mouse inside the element that is being dragged?
      // Use this to offset the dragging operation to avoid the element snapping to the top edge of itself
      // when being dragged. Allows the use to drag from wherever their mouse/finger touched
      this.currentDraggingYOffsetFromMouse = pageY - (boundingRectsOfDOM.top + window.scrollY);
      this.isDragging = true;
      this.dom.style.height = "".concat(this.uploadContainerDOM.clientHeight, "px");
      document.body.append(this.uploadContainerDOM);
      this.uploadContainerDOM.classList.add("dragging");
      ImageComponent.currentDraggingInstance = this;
      this.uploadContainerDOM.style.top = "".concat(pageY - this.currentDraggingYOffsetFromMouse, "px");
      this.uploadContainerDOM.style.left = "".concat(leftOffset, "px");
    }
  }, {
    key: "dragMoved",
    value: function dragMoved(pageY) {
      this.uploadContainerDOM.style.top = "".concat(pageY - this.currentDraggingYOffsetFromMouse, "px");

      // Check previous sibling and next sibling

      if (this.dom.previousElementSibling) {
        var prevElementSiblingYPosition = this.dom.previousElementSibling.getBoundingClientRect().top + window.scrollY;
        if (pageY < prevElementSiblingYPosition) {
          // Swap positions
          this.dom.parentElement.insertBefore(this.dom, this.dom.previousElementSibling);
        }
      }
      if (this.dom.nextElementSibling) {
        var nextElementSiblingYPosition = this.dom.nextElementSibling.getBoundingClientRect().top + window.scrollY;
        if (pageY > nextElementSiblingYPosition) {
          // Swap positions
          this.dom.parentElement.insertBefore(this.dom.nextElementSibling, this.dom);
        }
      }
    }
  }, {
    key: "dragEnded",
    value: function dragEnded() {
      this.isDragging = false;
      this.dom.style.height = null;
      this.dom.append(this.uploadContainerDOM);
      this.uploadContainerDOM.classList.remove("dragging");
      ImageComponent.currentDraggingInstance = null;
    }
  }], [{
    key: "componentFromDOM",
    value:
    /**
     * Gets an ImageComponent from an HTMLDivElement
     * @param {HTMLDivElement} dom
     */
    function componentFromDOM(dom) {
      var _iterator = _createForOfIteratorHelper(ImageComponent.cache),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var component = _step.value;
          if (component.dom === dom) {
            return component;
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
      return null;
    }
  }, {
    key: "removeFromCacheByID",
    value: function removeFromCacheByID(id) {
      for (var componentIndex in ImageComponent.cache) {
        var component = ImageComponent.cache[parseInt(componentIndex)];
        if (component.id === id) {
          ImageComponent.cache.splice(parseInt(componentIndex), 1);
          break;
        }
      }
    }
  }]);
}();
_ImageComponent = ImageComponent;
/** @type {ImageComponent[]} */
_defineProperty(ImageComponent, "cache", []);
_defineProperty(ImageComponent, "internalCounter", 0);
_defineProperty(ImageComponent, "componentsContainer", document.querySelector("#additional-image-components-container"));
/** @type {?ImageComponent} */
_defineProperty(ImageComponent, "currentDraggingInstance", null);
(function () {
  window.addEventListener("mousemove", /** @param {MouseEvent} e */function (e) {
    if (_ImageComponent.currentDraggingInstance !== null) {
      _ImageComponent.currentDraggingInstance.dragMoved(e.pageY);
    }
  });
  window.addEventListener("touchmove", /** @param {TouchEvent} e */function (e) {
    if (_ImageComponent.currentDraggingInstance !== null) {
      /** @type {Touch} */
      var firstTouch = e.touches[0];
      if (firstTouch) {
        e.preventDefault();
        _ImageComponent.currentDraggingInstance.dragMoved(firstTouch.pageY);
      }
    }
  }, {
    passive: false
  });
  window.addEventListener("mouseup", /** @param {MouseEvent} e */function (e) {
    if (_ImageComponent.currentDraggingInstance !== null) {
      _ImageComponent.currentDraggingInstance.dragEnded();
    }
  });
  window.addEventListener("touchend", /** @param {TouchEvent} e */function (e) {
    if (_ImageComponent.currentDraggingInstance !== null) {
      _ImageComponent.currentDraggingInstance.dragEnded();
    }
  }, {
    passive: false
  });
  window.addEventListener("touchcancel", /** @param {TouchEvent} e */function (e) {
    if (_ImageComponent.currentDraggingInstance !== null) {
      _ImageComponent.currentDraggingInstance.dragEnded();
    }
  }, {
    passive: false
  });
})();
export default ImageComponent;