function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
var NoServiceKeyword = /*#__PURE__*/function () {
  function NoServiceKeyword() {
    var _this = this;
    _classCallCheck(this, NoServiceKeyword);
    _defineProperty(this, "projectDescriptionTextField", document.querySelector("#project-description-input"));
    _defineProperty(this, "alertBox", document.querySelector("#no-service-keyword-warning"));
    _defineProperty(this, "alertBoxSelectedPrimaryServiceText", document.querySelector("#primary-service-text"));
    _defineProperty(this, "servicePageInput", document.querySelector("#service-page-id-input"));
    this.projectDescriptionTextField.addEventListener("input", function () {
      _this.onProjectDescriptionInput();
    });
    this.servicePageInput.addEventListener("change", function () {
      _this.onServicePageSelectMenuChanged();
    });
  }
  _createClass(NoServiceKeyword, [{
    key: "onProjectDescriptionInput",
    value: function onProjectDescriptionInput() {
      var servicePageName = this.getServicePageName();
      if (servicePageName !== null) {
        // Find this key phrase in the content
        if (this.doesProjectDescriptionIncludeText(servicePageName)) {
          // We're good
          this.hideWarning();
        } else {
          // Warn them
          this.showWarning();
        }
      }
    }
  }, {
    key: "onServicePageSelectMenuChanged",
    value: function onServicePageSelectMenuChanged() {
      this.onProjectDescriptionInput();
    }

    /**
     * Fetches the name of the selected service page, if any.
     */
  }, {
    key: "getServicePageName",
    value: function getServicePageName() {
      var pageID = parseInt(this.servicePageInput.value);
      if (pageID > 0) {
        return this.getServiceNameFromSelectMenu();
      } else {
        return null;
      }
    }
  }, {
    key: "doesProjectDescriptionIncludeText",
    value: function doesProjectDescriptionIncludeText(textToCheckFor) {
      return this.projectDescriptionTextField.value.toLowerCase().includes(textToCheckFor.toLowerCase());
    }
  }, {
    key: "getServiceNameFromSelectMenu",
    value: function getServiceNameFromSelectMenu() {
      return this.servicePageInput.options[this.servicePageInput.selectedIndex].textContent;
    }
  }, {
    key: "showWarning",
    value: function showWarning() {
      this.alertBoxSelectedPrimaryServiceText.textContent = this.getServiceNameFromSelectMenu().trim();
      this.alertBox.style.display = null;
    }
  }, {
    key: "hideWarning",
    value: function hideWarning() {
      this.alertBox.style.display = "none";
    }
  }]);
  return NoServiceKeyword;
}();
export { NoServiceKeyword as default };