function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
export var Paginator = /*#__PURE__*/function () {
  /**
   * Creates Paginator Element which displays page form, input, and previous/next buttons. Event listeners are created for next/previous buttons as well as form submission.
   * @param PaginatorElement
   */
  function Paginator(PaginatorElement) {
    var _this = this;
    _classCallCheck(this, Paginator);
    _defineProperty(this, "CurrentPage", void 0);
    _defineProperty(this, "MaxPages", void 0);
    _defineProperty(this, "PaginatorElement", void 0);
    _defineProperty(this, "PageForm", void 0);
    _defineProperty(this, "PageInput", void 0);
    _defineProperty(this, "MaxPagesElement", void 0);
    _defineProperty(this, "NextButton", void 0);
    _defineProperty(this, "PrevButton", void 0);
    _defineProperty(this, "OnPageManuallyEnteredCallbacks", []);
    _defineProperty(this, "OnPageNextCallbacks", []);
    _defineProperty(this, "OnPagePrevCallbacks", []);
    this.CurrentPage = 1;
    this.MaxPages = 1;
    this.PaginatorElement = PaginatorElement;
    this.PageForm = this.PaginatorElement.querySelector("form");
    this.PageInput = this.PaginatorElement.querySelector("form input[type=\"number\"]");
    this.MaxPagesElement = this.PaginatorElement.querySelector(".paginator-max-pages");
    this.NextButton = this.PaginatorElement.querySelector(".next-button");
    this.PrevButton = this.PaginatorElement.querySelector(".prev-button");
    this.PageForm.addEventListener("submit", function (e) {
      e.preventDefault();
      _this.OnPageFormSubmit();
    });
    this.NextButton.addEventListener("click", function () {
      _this.OnNextButtonClicked();
    });
    this.PrevButton.addEventListener("click", function () {
      _this.OnPrevButtonClicked();
    });
  }
  /**
   * Updates current page and sets value based on new page number.
   * @param CurrentPage
   */
  return _createClass(Paginator, [{
    key: "SetCurrentPage",
    value: function SetCurrentPage(CurrentPage) {
      this.CurrentPage = CurrentPage;
      this.PageInput.value = String(CurrentPage);
    }
    /**
     * Updates the Max Page number and displays that total number.
     * @param MaxPages
     */
  }, {
    key: "SetMaxPages",
    value: function SetMaxPages(MaxPages) {
      this.MaxPages = MaxPages;
      this.MaxPagesElement.textContent = String(MaxPages);
    }
    /**
     * Callback for manually entered page number.
     * @param callback
     */
  }, {
    key: "OnPageManuallyEntered",
    value: function OnPageManuallyEntered(callback) {
      this.OnPageManuallyEnteredCallbacks.push(callback);
    }
    /**
     * Callback for when the next button is clicked.
     * @param callback
     */
  }, {
    key: "OnPageNext",
    value: function OnPageNext(callback) {
      this.OnPageNextCallbacks.push(callback);
    }
    /**
     * Callback for when the previous button is clicked.
     * @param callback
     */
  }, {
    key: "OnPagePrev",
    value: function OnPagePrev(callback) {
      this.OnPagePrevCallbacks.push(callback);
    }
    /**
     * Parses the page input as an integer and, if it's a valid integer, fires all the connected event listeners.
     */
  }, {
    key: "OnPageFormSubmit",
    value: function OnPageFormSubmit() {
      var newPage = parseInt(this.PageInput.value);
      if (!isNaN(newPage)) {
        if (newPage > 0 && newPage <= this.MaxPages) {
          this.SetCurrentPage(newPage);
          var _iterator = _createForOfIteratorHelper(this.OnPageManuallyEnteredCallbacks),
            _step;
          try {
            for (_iterator.s(); !(_step = _iterator.n()).done;) {
              var callback = _step.value;
              callback(newPage);
            }
          } catch (err) {
            _iterator.e(err);
          } finally {
            _iterator.f();
          }
        }
      }
    }
    /**
     * Method when next button is clicked. Adds +1 to current page.
     */
  }, {
    key: "OnNextButtonClicked",
    value: function OnNextButtonClicked() {
      var possibleNextPageNumber = this.CurrentPage + 1;
      if (possibleNextPageNumber <= this.MaxPages) {
        this.SetCurrentPage(possibleNextPageNumber);
        var _iterator2 = _createForOfIteratorHelper(this.OnPageNextCallbacks),
          _step2;
        try {
          for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
            var callback = _step2.value;
            callback(possibleNextPageNumber);
          }
        } catch (err) {
          _iterator2.e(err);
        } finally {
          _iterator2.f();
        }
      }
    }
    /**
     * Method when previous button is clicked. Subtracts -1 from current page.
     */
  }, {
    key: "OnPrevButtonClicked",
    value: function OnPrevButtonClicked() {
      var possiblePrevPageNumber = this.CurrentPage - 1;
      if (possiblePrevPageNumber > 0) {
        this.SetCurrentPage(possiblePrevPageNumber);
        var _iterator3 = _createForOfIteratorHelper(this.OnPagePrevCallbacks),
          _step3;
        try {
          for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
            var callback = _step3.value;
            callback(possiblePrevPageNumber);
          }
        } catch (err) {
          _iterator3.e(err);
        } finally {
          _iterator3.f();
        }
      }
    }
  }]);
}();