function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
export var RatingStars = /*#__PURE__*/function () {
  /**
   * @param {HTMLDivElement} parentElement
   */
  function RatingStars(parentElement) {
    var _this = this;
    _classCallCheck(this, RatingStars);
    _defineProperty(this, "EventListeners", []);
    _defineProperty(this, "Stars", void 0);
    _defineProperty(this, "ParentElement", void 0);
    this.EventListeners = [];
    this.Stars = Array.from(parentElement.querySelectorAll("i"));
    this.ParentElement = parentElement;
    parentElement.setAttribute("rating", "0");
    var _iterator = _createForOfIteratorHelper(this.Stars),
      _step;
    try {
      var _loop = function _loop() {
        var star = _step.value;
        star.addEventListener("mouseover", function (e) {
          e.stopPropagation();
          _this.OnStarHovered(star);
        });
        star.addEventListener("click", function () {
          parentElement.setAttribute("rating", String(_this.Stars.indexOf(star) + 1));
          var _iterator2 = _createForOfIteratorHelper(_this.EventListeners),
            _step2;
          try {
            for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
              var callback = _step2.value;
              /**
               * Fire the event listener callbacks.
               */
              callback(_this.Stars.indexOf(star) + 1);
            }
          } catch (err) {
            _iterator2.e(err);
          } finally {
            _iterator2.f();
          }
        });
      };
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        _loop();
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }
    parentElement.addEventListener("mouseleave", function () {
      _this.HighlightToRating(parentElement.getAttribute("rating"));
    });
  }
  return _createClass(RatingStars, [{
    key: "HighlightToRating",
    value: function HighlightToRating(rating) {
      /**
       * Remove color from all stars.
       */
      var _iterator3 = _createForOfIteratorHelper(this.Stars),
        _step3;
      try {
        for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
          var star = _step3.value;
          if (star.classList.contains("colored")) {
            star.classList.remove("colored");
          }
        }
      } catch (err) {
        _iterator3.e(err);
      } finally {
        _iterator3.f();
      }
      if (rating > 0) {
        var currentStar = this.Stars[rating - 1];
        /**
         * Color current star and previous ones.
         */
        do {
          currentStar.classList.add("colored");
          currentStar = currentStar.previousElementSibling;
        } while (currentStar !== null);
      }
    }
    /**
     * When the mouse goes over a star.
     * @param {HTMLElement} currentStar
     */
  }, {
    key: "OnStarHovered",
    value: function OnStarHovered(currentStar) {
      this.HighlightToRating(this.Stars.indexOf(currentStar) + 1);
    }
  }, {
    key: "OnStarSelected",
    value: function OnStarSelected(callback) {
      this.EventListeners.push(callback);
    }
  }]);
}();