function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
var NoServiceKeyword = /*#__PURE__*/function () {
  function NoServiceKeyword() {
    var _this = this;
    _classCallCheck(this, NoServiceKeyword);
    _defineProperty(this, "projectDescriptionTextField", document.querySelector("#project-description-input"));
    _defineProperty(this, "alertBox", document.querySelector("#no-service-keyword-warning"));
    _defineProperty(this, "alertBoxSelectedPrimaryServiceText", document.querySelector("#primary-service-text"));
    _defineProperty(this, "servicePageInput", document.querySelector("#service-page-id-input"));
    this.projectDescriptionTextField.addEventListener("input", function () {
      _this.onProjectDescriptionInput();
    });
    this.servicePageInput.addEventListener("change", function () {
      _this.onServicePageSelectMenuChanged();
    });
  }
  return _createClass(NoServiceKeyword, [{
    key: "onProjectDescriptionInput",
    value: function onProjectDescriptionInput() {
      var servicePageName = this.getServicePageName();
      if (servicePageName !== null) {
        // Find this key phrase in the content
        if (this.doesProjectDescriptionIncludeText(servicePageName)) {
          // We're good
          this.hideWarning();
        } else {
          // Warn them
          this.showWarning();
        }
      }
    }
  }, {
    key: "onServicePageSelectMenuChanged",
    value: function onServicePageSelectMenuChanged() {
      this.onProjectDescriptionInput();
    }
    /**
     * Fetches the name of the selected service page, if any.
     */
  }, {
    key: "getServicePageName",
    value: function getServicePageName() {
      var pageID = parseInt(this.servicePageInput.value);
      if (pageID > 0) {
        return this.getServiceNameFromSelectMenu();
      } else {
        return null;
      }
    }
  }, {
    key: "doesProjectDescriptionIncludeText",
    value: function doesProjectDescriptionIncludeText(textToCheckFor) {
      return this.projectDescriptionTextField.value.toLowerCase().includes(textToCheckFor.toLowerCase());
    }
  }, {
    key: "getServiceNameFromSelectMenu",
    value: function getServiceNameFromSelectMenu() {
      return this.servicePageInput.options[this.servicePageInput.selectedIndex].textContent;
    }
  }, {
    key: "showWarning",
    value: function showWarning() {
      this.alertBoxSelectedPrimaryServiceText.textContent = this.getServiceNameFromSelectMenu().trim();
      this.alertBox.style.display = null;
    }
  }, {
    key: "hideWarning",
    value: function hideWarning() {
      this.alertBox.style.display = "none";
    }
  }]);
}();
export { NoServiceKeyword as default };