<?php
	require_once __DIR__ . "/../../vendor/autoload.php";
	require_once __DIR__ . "/../nox-env.php";

	use Nox\ORM\Abyss;
	use Nox\ORM\DatabaseCredentials;
	use Page\Page;
	use PageEditor\PageEditorService;

	// Load the credentials for any and all databases used by the models
	Abyss::addCredentials(new DatabaseCredentials(
		host: NoxEnv::MYSQL_HOST,
		username: NoxEnv::MYSQL_USERNAME,
		password: NoxEnv::MYSQL_PASSWORD,
		database: NoxEnv::MYSQL_DB_NAME,
		port: NoxEnv::MYSQL_PORT,
	));

	if (NoxEnv::DEV_ENV !== "development"){
		print("Will not delete all pages in a production environment.");
		exit();
	}

	// deletePage() requires the current user to be set
	\Accounts\Account::$currentUser_cache = \Accounts\Account::query()[0];

	/** @var Page[] $pages */
	$pages = Page::query();

	foreach($pages as $page){
		PageEditorService::deletePage($page->id);
	}
