<?php
	namespace SectionParser;

	use PHPUnit\Framework\TestCase;

	final class SectionParserTest extends TestCase {

		public function testSectionParserCreatesBlankString(): void{
			$testString =  <<<HTML
				{% begin testSection %}
					Hello Content
				{% end testSection %}	
			HTML;

			$sectionParser = new SectionParser();
			$sections = $sectionParser->parseSections($testString);
			$this->assertNotEmpty($sections);
			$this->assertEmpty(
				actual: trim($testString),
				message: $testString,
			);

			$testString =  <<<HTML
				{% begin testSection %}Hello Content
				{% end testSection %}	
			HTML;

			$sectionParser = new SectionParser();
			$sections = $sectionParser->parseSections($testString);
			$this->assertNotEmpty($sections);
			$this->assertEmpty(
				actual: trim($testString),
				message: $testString,
			);

			$testString =  <<<HTML
				{% begin testSection %}Hello Content{% end testSection %}	
			HTML;

			$sectionParser = new SectionParser();
			$sections = $sectionParser->parseSections($testString);
			$this->assertNotEmpty($sections);
			$this->assertEmpty(
				actual: trim($testString),
				message: $testString,
			);

			$testString =  <<<HTML
				{% begin testSection %}
				Hello Content  {% end testSection %}	
			HTML;

			$sectionParser = new SectionParser();
			$sections = $sectionParser->parseSections($testString);
			$this->assertNotEmpty($sections);
			$this->assertEmpty(
				actual: trim($testString),
				message: $testString,
			);
		}

		public function testProperNameIsMatched(): void{
			$testString =  <<<HTML
				{% begin testSection %}
					Hello Content
				{% end testSection %}	
				{% begin testSection2 %}
					Hello Content
				{% end testSection2 %}	
			HTML;

			$sectionParser = new SectionParser();
			$sections = $sectionParser->parseSections($testString);
			$this->assertNotEmpty($sections);
			$this->assertEquals(
				expected: "testSection",
				actual: $sections[0]->name,
			);
		}
	}