<?php

	namespace CompatibilityLayerTests;

	use CompatibilityLayer\LayoutVariableConverter;
	use PHPUnit\Framework\TestCase;

	final class LayoutGlobalsConversionTest extends TestCase
	{

		public function testConvertCityPageLayoutGlobals(): void
		{
			$layoutFile = __DIR__ . "/Resources/OldCityPageLayout.php";
			$layoutContents = file_get_contents($layoutFile);

			$numGlobalsDefined = LayoutVariableConverter::getNumberOfGlobalsDefined($layoutContents);
			$this->assertEquals(
				expected: 10,
				actual:$numGlobalsDefined,
			);

			// Replace them
			$newLayoutContents = LayoutVariableConverter::replaceGlobalVariablesWithPHPDocComment($layoutContents);
			$numGlobalsDefinedInNewLayout = LayoutVariableConverter::getNumberOfGlobalsDefined($newLayoutContents);
			$this->assertEquals(
				expected: 0,
				actual: $numGlobalsDefinedInNewLayout,
			);
		}

	}