<?php
	namespace ClientProjectFormTests;

	require_once __DIR__ . "/../../vendor/autoload.php";
	require_once __DIR__ . "/../../uplift-core/nox-env.php";

	use ClientProjectForm\ClientProjectFormService;
	use PHPUnit\Framework\TestCase;

	final class ServiceTest extends TestCase
	{
		public function testAddLinkToContent(): void{
			$projectDescription = "We performed tree trimming service for the parliament in Greenland.";
			$service = "Tree Trimming";
			$serviceLink = "/services/tree-trimming";
			$expectedResult = "We performed <a href=\"$serviceLink\">tree trimming</a> service for the parliament in Greenland.";

			$linkedProjectDescription = ClientProjectFormService::addServiceLinkToContent($projectDescription, $service, $serviceLink);
			$this->assertEquals(
				expected: $expectedResult,
				actual: $linkedProjectDescription,
			);
		}

		public function testAppendLinkToContent(): void{
			$projectDescription = "We performed trimming service for the parliament in Greenland.";
			$service = "Tree Trimming";
			$serviceLink = "/services/tree-trimming";
			$expectedResult = "We performed trimming service for the parliament in Greenland.\n\n<strong>Service provided:</strong> <a href=\"$serviceLink\">$service</a>";

			$linkedProjectDescription = ClientProjectFormService::addServiceLinkToContent($projectDescription, $service, $serviceLink);
			$this->assertEquals(
				expected: $expectedResult,
				actual: $linkedProjectDescription,
			);
		}

		public function testRecentProjectsShortcodeGetsInjected(): void{
			$projectTagID = 37;
			$testString = <<<HTML
<h1>Albany's Top Plumber</h1>
	Here's a look at some of our oustanding services:
</p>
<ul class="grid grid-xxl-2">
	<li>Faucet installation</li>
	<li>Gas leak detection</li>
	<li><a href="SERVICELINK">Sewer line repairs</a></li>
	<li>Toilet repairs</li>
	<li>Water heater repairs</li>
	<li>And more!</li>
</ul>
<p>
	Are you interested in utilizing any of the above services? Do you live here in the Albany area? Then give us a call today at Big Brothers Plumbing Inc so we can get started as soon as possible!
</p>
{{ get-recent-projects num-projects="2" columns="1" included-project-tags="[]" autofill="0" }}
HTML;

			$expectedResult = <<<HTML
<h1>Albany's Top Plumber</h1>
	Here's a look at some of our oustanding services:
</p>
<ul class="grid grid-xxl-2">
	<li>Faucet installation</li>
	<li>Gas leak detection</li>
	<li><a href="SERVICELINK">Sewer line repairs</a></li>
	<li>Toilet repairs</li>
	<li>Water heater repairs</li>
	<li>And more!</li>
</ul>
<p>
	Are you interested in utilizing any of the above services? Do you live here in the Albany area? Then give us a call today at Big Brothers Plumbing Inc so we can get started as soon as possible!
</p>
{{ get-recent-projects num-projects="2" columns="1" included-project-tags="[37]" autofill="0" }}
HTML;

			$modifiedString = ClientProjectFormService::addProjectTagToRecentProjectsShortcode($projectTagID, $testString);
			$this->assertEquals($expectedResult, $modifiedString);
		}

		public function testRecentProjectsShortcodeDoesntChange(): void{
			$projectTagID = 37;
			$testString = <<<HTML
<h1>Albany's Top Plumber</h1>
	Here's a look at some of our oustanding services:
</p>
<ul class="grid grid-xxl-2">
	<li>Faucet installation</li>
	<li>Gas leak detection</li>
	<li><a href="SERVICELINK">Sewer line repairs</a></li>
	<li>Toilet repairs</li>
	<li>Water heater repairs</li>
	<li>And more!</li>
</ul>
<p>
	Are you interested in utilizing any of the above services? Do you live here in the Albany area? Then give us a call today at Big Brothers Plumbing Inc so we can get started as soon as possible!
</p>
{{ get-recent-projects num-projects="2" columns="1" included-project-tags="[37]" autofill="0" }}
HTML;

			$expectedResult = <<<HTML
<h1>Albany's Top Plumber</h1>
	Here's a look at some of our oustanding services:
</p>
<ul class="grid grid-xxl-2">
	<li>Faucet installation</li>
	<li>Gas leak detection</li>
	<li><a href="SERVICELINK">Sewer line repairs</a></li>
	<li>Toilet repairs</li>
	<li>Water heater repairs</li>
	<li>And more!</li>
</ul>
<p>
	Are you interested in utilizing any of the above services? Do you live here in the Albany area? Then give us a call today at Big Brothers Plumbing Inc so we can get started as soon as possible!
</p>
{{ get-recent-projects num-projects="2" columns="1" included-project-tags="[37]" autofill="0" }}
HTML;

			$modifiedString = ClientProjectFormService::addProjectTagToRecentProjectsShortcode($projectTagID, $testString);
			$this->assertEquals($expectedResult, $modifiedString);
		}

		public function testRecentProjectsShortcodeGetsInjectedByAppending(): void{
			$projectTagID = 37;
			$testString = <<<HTML
<h1>Albany's Top Plumber</h1>
	Here's a look at some of our oustanding services:
</p>
<ul class="grid grid-xxl-2">
	<li>Faucet installation</li>
	<li>Gas leak detection</li>
	<li><a href="SERVICELINK">Sewer line repairs</a></li>
	<li>Toilet repairs</li>
	<li>Water heater repairs</li>
	<li>And more!</li>
</ul>
<p>
	Are you interested in utilizing any of the above services? Do you live here in the Albany area? Then give us a call today at Big Brothers Plumbing Inc so we can get started as soon as possible!
</p>
{{ get-recent-projects num-projects="2" columns="1" included-project-tags="[12]" autofill="0" }}
HTML;

			$expectedResult = <<<HTML
<h1>Albany's Top Plumber</h1>
	Here's a look at some of our oustanding services:
</p>
<ul class="grid grid-xxl-2">
	<li>Faucet installation</li>
	<li>Gas leak detection</li>
	<li><a href="SERVICELINK">Sewer line repairs</a></li>
	<li>Toilet repairs</li>
	<li>Water heater repairs</li>
	<li>And more!</li>
</ul>
<p>
	Are you interested in utilizing any of the above services? Do you live here in the Albany area? Then give us a call today at Big Brothers Plumbing Inc so we can get started as soon as possible!
</p>
{{ get-recent-projects num-projects="2" columns="1" included-project-tags="[12,37]" autofill="0" }}
HTML;

			$modifiedString = ClientProjectFormService::addProjectTagToRecentProjectsShortcode($projectTagID, $testString);
			$this->assertEquals($expectedResult, $modifiedString);
		}
	}
