<?php

	namespace Accounts;

	use Nox\Http\JSON\JSONError;
	use Nox\Http\Request;
	use Nox\Http\RequestPayload;
	use Nox\Http\TextPayload;
	use PHPUnit\Framework\TestCase;

	final class AccountsControllerTests extends TestCase
	{

		/**
		 * @return void
		 */
		public function testLoginAccount(): void{
			$usernamePayload = new TextPayload();
			$usernamePayload->name = "username";
			$usernamePayload->contents = "test";

			$passwordPayload = new TextPayload();
			$passwordPayload->name = "password";
			$passwordPayload->contents = "test";

			$payload = new RequestPayload();
			$payload->pushPayload($usernamePayload);
			$payload->pushPayload($passwordPayload);

			$request = new Request();
			$request->setPayload($payload);

			$controller = new AccountsController();
			$response = $controller->loginAccount($request);

			$this->assertInstanceOf(
				expected: JSONError::class,
				actual: $response
			);

			// TODO finish all possible tests here
		}
	}